/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.common.Event;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.ipc.EventHandler;
import edu.stanford.protege.webprotege.ipc.ExecutionContext;
import edu.stanford.protege.webprotege.ipc.impl.EventHandlerMethodNotImplemented;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

public class RabbitMQEventHandlerWrapper<T extends Event>
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQEventHandlerWrapper.class);
    private final List<EventHandler<? extends Event>> eventHandlers;
    private final ObjectMapper objectMapper;

    public RabbitMQEventHandlerWrapper(List<EventHandler<? extends Event>> eventHandlers, ObjectMapper objectMapper) {
        this.eventHandlers = eventHandlers;
        this.objectMapper = objectMapper;
    }

    public void onMessage(Message message) {
        EventHandler eventHandler = this.eventHandlers.stream().filter(handler -> {
            String channel = String.valueOf(message.getMessageProperties().getHeaders().get("webprotege_channel"));
            return channel.contains(handler.getChannelName());
        }).findFirst().orElse(null);
        if (eventHandler != null) {
            try {
                Event event = (Event)this.objectMapper.readValue(message.getBody(), eventHandler.getEventClass());
                String accessToken = String.valueOf(message.getMessageProperties().getHeaders().get("webprotege_accessToken"));
                String userId = (String)message.getMessageProperties().getHeaders().get("webprotege_userId");
                if (accessToken != null && !accessToken.isEmpty() && !"null".equalsIgnoreCase(accessToken)) {
                    ExecutionContext executionContext = new ExecutionContext(UserId.valueOf((String)userId), accessToken);
                    try {
                        eventHandler.handleEvent(event, executionContext);
                    }
                    catch (EventHandlerMethodNotImplemented e) {
                        eventHandler.handleEvent(event);
                    }
                } else {
                    eventHandler.handleEvent(event);
                }
            }
            catch (IOException e) {
                logger.error("Error when handling event " + message.getMessageProperties().getMessageId(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

