/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.common.Request;
import edu.stanford.protege.webprotege.common.Response;
import edu.stanford.protege.webprotege.ipc.CommandExecutionException;
import edu.stanford.protege.webprotege.ipc.CommandExecutor;
import edu.stanford.protege.webprotege.ipc.ExecutionContext;
import edu.stanford.protege.webprotege.ipc.MessageBodyDeserializationException;
import edu.stanford.protege.webprotege.ipc.MessageBodySerializationException;
import edu.stanford.protege.webprotege.ipc.MessageErrorHeaderDeserializationException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

public class CommandExecutorImpl<Q extends Request<R>, R extends Response>
implements CommandExecutor<Q, R> {
    private static final Logger logger = LoggerFactory.getLogger(CommandExecutorImpl.class);
    private final Class<R> responseClass;
    private ObjectMapper objectMapper;
    private AsyncRabbitTemplate asyncRabbitTemplate;

    public CommandExecutorImpl(Class<R> responseClass) {
        this.responseClass = responseClass;
    }

    @Override
    public CompletableFuture<R> execute(Q request, ExecutionContext executionContext) {
        try {
            byte[] json = this.objectMapper.writeValueAsBytes(request);
            Message rabbitMsg = new Message(json);
            Map headers = rabbitMsg.getMessageProperties().getHeaders();
            headers.put("webprotege_accessToken", executionContext.jwt());
            headers.put("webprotege_userId", executionContext.userId().id());
            headers.put("webprotege_methodName", request.getChannel());
            return this.asyncRabbitTemplate.sendAndReceive(request.getChannel(), rabbitMsg).thenApply(this::handleResponse);
        }
        catch (JsonProcessingException e) {
            MessageBodySerializationException serializationException = new MessageBodySerializationException((Request<?>)request, (Throwable)e);
            logger.error("Error when serializing request", (Throwable)e);
            return CompletableFuture.failedFuture(serializationException);
        }
        catch (AmqpException e) {
            logger.error("Error thrown by message broker", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
        catch (Exception e) {
            logger.error("Other error when executing request", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
    }

    private R handleResponse(Message rabbitResponseMsg) {
        String errorHeader = (String)rabbitResponseMsg.getMessageProperties().getHeaders().get("webprotege_error");
        if (errorHeader != null) {
            try {
                logger.info("Found error on response {}. Action : {}", (Object)errorHeader, rabbitResponseMsg.getMessageProperties().getHeaders().get("webprotege_methodName"));
                throw (CommandExecutionException)this.objectMapper.readValue(errorHeader, CommandExecutionException.class);
            }
            catch (JsonProcessingException e) {
                logger.error("Error deserializing CommandExecutionException. Error header: {}. Exception {}", new Object[]{errorHeader, e.getMessage(), e});
                throw new MessageErrorHeaderDeserializationException(errorHeader, (IOException)((Object)e));
            }
        }
        try {
            return (R)((Response)this.objectMapper.readValue(rabbitResponseMsg.getBody(), this.responseClass));
        }
        catch (IOException e) {
            logger.error("Error deserializing reply message. Body: {} Cause: {}", new Object[]{rabbitResponseMsg.getBody(), e.getMessage(), e});
            throw new MessageBodyDeserializationException(rabbitResponseMsg.getBody(), e);
        }
    }

    @Autowired
    @Qualifier(value="asyncRabbitTemplate")
    @Lazy
    public void setAsyncRabbitTemplate(AsyncRabbitTemplate asyncRabbitTemplate) {
        this.asyncRabbitTemplate = asyncRabbitTemplate;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

