/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc;

import edu.stanford.protege.webprotege.ipc.MessageProcessingException;
import java.io.IOException;
import org.springframework.util.StringUtils;

public class MessageBodyDeserializationException
extends MessageProcessingException {
    private final byte[] messageBody;

    public MessageBodyDeserializationException(byte[] messageBody, IOException cause) {
        super(MessageBodyDeserializationException.getExceptionMessage(messageBody, cause), cause);
        this.messageBody = messageBody;
    }

    private static String getExceptionMessage(byte[] messageBody, IOException cause) {
        String truncatedMessageBody = StringUtils.truncate((CharSequence)new String(messageBody), (int)100);
        return "Error deserializing reply message body. Cause: " + cause.getMessage() + " Body: " + truncatedMessageBody;
    }

    public byte[] getMessageBody() {
        return this.messageBody;
    }
}

