/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.springframework.http.HttpStatus;

@JsonIncludeProperties(value={"statusCode", "causeClassName", "causeMessage"})
public class CommandExecutionException
extends RuntimeException {
    private final int statusCode;
    private final String causeClassName;
    private final String causeMessage;

    public CommandExecutionException(HttpStatus status) {
        this(status, "", "");
    }

    public CommandExecutionException(HttpStatus status, String causeClassName, String causeMessage) {
        this(status.value(), causeClassName, causeMessage);
    }

    @JsonCreator
    public CommandExecutionException(@JsonProperty(value="statusCode") int statusCode, @JsonProperty(value="causeClassName") String causeClassName, @JsonProperty(value="causeMessage") String causeMessage) {
        this.statusCode = statusCode;
        this.causeClassName = Objects.requireNonNullElse(causeClassName, "");
        this.causeMessage = Objects.requireNonNullElse(causeMessage, "");
    }

    public static CommandExecutionException of(Throwable throwable) {
        if (throwable instanceof CommandExecutionException) {
            CommandExecutionException commandExecutionException = (CommandExecutionException)throwable;
            return commandExecutionException;
        }
        return new CommandExecutionException(HttpStatus.INTERNAL_SERVER_ERROR, throwable.getClass().getName(), throwable.getMessage());
    }

    public static CommandExecutionException of(Throwable throwable, HttpStatus httpStatus) {
        return new CommandExecutionException(httpStatus, throwable.getClass().getName(), throwable.getMessage());
    }

    public static CommandExecutionException of(Throwable throwable, HttpStatus httpStatus, String causeMessage) {
        return new CommandExecutionException(httpStatus, throwable.getClass().getName(), causeMessage);
    }

    public static CommandExecutionException of(HttpStatus httpStatus, String errorMessage) {
        return new CommandExecutionException(httpStatus, "", errorMessage);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @JsonIgnore
    public HttpStatus getStatus() {
        return HttpStatus.resolve((int)this.statusCode);
    }

    @Override
    public String getMessage() {
        return "Error " + this.statusCode + " (" + this.getStatus().getReasonPhrase() + ") [" + this.causeClassName + "] " + this.causeMessage;
    }

    @JsonProperty(value="causeClassName")
    public String getCauseClassName() {
        return this.causeClassName;
    }

    @JsonProperty(value="causeMessage")
    public String getCauseMessage() {
        return this.causeMessage;
    }
}

