/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.common.Event;
import edu.stanford.protege.webprotege.common.ProjectEvent;
import edu.stanford.protege.webprotege.ipc.EventDispatcher;
import edu.stanford.protege.webprotege.ipc.ExecutionContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class RabbitMQEventDispatcher
implements EventDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQEventDispatcher.class);
    private final String applicationName;
    private final ObjectMapper objectMapper;
    private final RabbitTemplate eventRabbitTemplate;

    public RabbitMQEventDispatcher(@Value(value="${spring.application.name}") String applicationName, ObjectMapper objectMapper, @Qualifier(value="eventRabbitTemplate") RabbitTemplate eventRabbitTemplate) {
        this.applicationName = applicationName;
        this.objectMapper = objectMapper;
        this.eventRabbitTemplate = eventRabbitTemplate;
    }

    @Override
    public void dispatchEvent(Event event, ExecutionContext executionContext) {
        try {
            byte[] value = this.objectMapper.writeValueAsBytes((Object)event);
            Message message = MessageBuilder.withBody((byte[])value).build();
            this.getJsonTypeName(event).ifPresent(typeName -> message.getMessageProperties().getHeaders().put("webprotege_eventType", typeName));
            message.getMessageProperties().getHeaders().put("webprotege_channel", event.getChannel());
            if (executionContext != null) {
                message.getMessageProperties().getHeaders().put("webprotege_accessToken", executionContext.jwt());
                message.getMessageProperties().getHeaders().put("webprotege_userId", executionContext.userId().id());
            }
            message.getMessageProperties().setHeader("webprotege_serviceName", (Object)this.applicationName);
            if (event instanceof ProjectEvent) {
                String projectId = ((ProjectEvent)event).projectId().value();
                message.getMessageProperties().getHeaders().put("webprotege_projectId", projectId);
            }
            this.eventRabbitTemplate.convertAndSend("webprotege-event-exchange", "", (Object)message);
        }
        catch (JsonProcessingException e) {
            logger.warn("Could not serialize event: {}", (Object)event, (Object)e);
        }
        catch (AmqpException e) {
            logger.warn("Could not send event message: {}", (Object)event, (Object)e);
        }
    }

    @Override
    public void dispatchEvent(Event event) {
        this.dispatchEvent(event, null);
    }

    private Optional<String> getJsonTypeName(Event event) {
        JsonTypeName annotation = event.getClass().getAnnotation(JsonTypeName.class);
        return Optional.ofNullable(annotation).map(JsonTypeName::value);
    }
}

