/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.Channel;
import edu.stanford.protege.webprotege.common.Event;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.ipc.EventHandler;
import edu.stanford.protege.webprotege.ipc.ExecutionContext;
import edu.stanford.protege.webprotege.ipc.impl.EventHandlerMethodNotImplemented;
import edu.stanford.protege.webprotege.ipc.util.CorrelationMDCUtil;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;

public class RabbitMQEventHandlerWrapper<T extends Event>
implements ChannelAwareMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQEventHandlerWrapper.class);
    private final List<EventHandler<? extends Event>> eventHandlers;
    private final ObjectMapper objectMapper;

    public RabbitMQEventHandlerWrapper(List<EventHandler<? extends Event>> eventHandlers, ObjectMapper objectMapper) {
        this.eventHandlers = eventHandlers;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message, Channel channel) throws Exception {
        block9: {
            String correlationId = message.getMessageProperties().getCorrelationId();
            try {
                CorrelationMDCUtil.setCorrelationId(correlationId);
                EventHandler eventHandler = this.eventHandlers.stream().filter(handler -> {
                    String channgelString = String.valueOf(message.getMessageProperties().getHeaders().get("webprotege_channel"));
                    return channgelString.contains(handler.getChannelName());
                }).findFirst().orElse(null);
                if (eventHandler == null) break block9;
                try {
                    Event event = (Event)this.objectMapper.readValue(message.getBody(), eventHandler.getEventClass());
                    String accessToken = String.valueOf(message.getMessageProperties().getHeaders().get("webprotege_accessToken"));
                    String userId = (String)message.getMessageProperties().getHeaders().get("webprotege_userId");
                    if (accessToken != null && !accessToken.isEmpty() && !"null".equalsIgnoreCase(accessToken)) {
                        ExecutionContext executionContext = new ExecutionContext(UserId.valueOf((String)userId), accessToken, correlationId);
                        try {
                            eventHandler.handleEvent(event, executionContext);
                        }
                        catch (EventHandlerMethodNotImplemented e) {
                            eventHandler.handleEvent(event);
                        }
                        break block9;
                    }
                    eventHandler.handleEvent(event);
                }
                catch (StreamReadException | DatabindException e) {
                    logger.error("Could not parse event. Event body: {}. Error: {}", new Object[]{message.getBody(), e.getMessage(), e});
                    channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                }
                catch (IOException e) {
                    logger.error("Error when handling event " + message.getMessageProperties().getMessageId(), (Throwable)e);
                    channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                }
            }
            finally {
                CorrelationMDCUtil.clearCorrelationId();
            }
        }
    }
}

