/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import edu.stanford.protege.webprotege.authorization.AuthorizationStatus;
import edu.stanford.protege.webprotege.authorization.Capability;
import edu.stanford.protege.webprotege.authorization.GetAuthorizationStatusRequest;
import edu.stanford.protege.webprotege.authorization.GetAuthorizationStatusResponse;
import edu.stanford.protege.webprotege.authorization.Resource;
import edu.stanford.protege.webprotege.authorization.Subject;
import edu.stanford.protege.webprotege.common.Request;
import edu.stanford.protege.webprotege.common.Response;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.ipc.AuthorizedCommandHandler;
import edu.stanford.protege.webprotege.ipc.CommandExecutionException;
import edu.stanford.protege.webprotege.ipc.CommandExecutor;
import edu.stanford.protege.webprotege.ipc.CommandHandler;
import edu.stanford.protege.webprotege.ipc.ExecutionContext;
import edu.stanford.protege.webprotege.ipc.util.CorrelationMDCUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import reactor.core.publisher.Mono;

public class RabbitMqCommandHandlerWrapper<Q extends Request<R>, R extends Response>
implements ChannelAwareMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMqCommandHandlerWrapper.class);
    private final List<CommandHandler<? extends Request, ? extends Response>> handlers;
    private final String applicationName;
    private final ObjectMapper objectMapper;
    private final CommandExecutor<GetAuthorizationStatusRequest, GetAuthorizationStatusResponse> authorizationStatusExecutor;

    public RabbitMqCommandHandlerWrapper(@Value(value="${spring.application.name}") String applicationName, List<CommandHandler<? extends Request, ? extends Response>> handlers, ObjectMapper objectMapper, CommandExecutor<GetAuthorizationStatusRequest, GetAuthorizationStatusResponse> authorizationStatusExecutor) {
        this.applicationName = applicationName;
        this.handlers = handlers;
        this.objectMapper = objectMapper;
        this.authorizationStatusExecutor = authorizationStatusExecutor;
    }

    public void onMessage(Message message, Channel channel) throws Exception {
        String replyChannel = message.getMessageProperties().getReplyTo();
        String correlationId = (String)message.getMessageProperties().getHeaders().get("webprotege_correlationId");
        if (correlationId == null) {
            logger.warn("webprotege_correlationId header is missing. Setting a new ID.");
            CorrelationMDCUtil.setCorrelationId(UUID.randomUUID().toString());
        } else {
            CorrelationMDCUtil.setCorrelationId(correlationId);
        }
        if (replyChannel == null) {
            String errorMessage = "webprotege_replyChannel header is missing.  Cannot reply to message.";
            this.replyWithBadRequest(message, channel, errorMessage, correlationId);
            return;
        }
        String userId = (String)message.getMessageProperties().getHeaders().get("webprotege_userId");
        if (userId == null) {
            String errorMessage = "webprotege_userId header is missing.  Cannot process message.  Message reply topic: " + replyChannel;
            this.replyWithBadRequest(message, channel, errorMessage, correlationId);
            return;
        }
        String accessToken = String.valueOf(message.getMessageProperties().getHeaders().get("webprotege_accessToken"));
        if (accessToken == null) {
            String errorMessage = "webprotege_accessToken header is missing.  Cannot process message.  Message reply topic: " + replyChannel;
            this.replyWithBadRequest(message, channel, errorMessage, correlationId);
            return;
        }
        String messageType = (String)message.getMessageProperties().getHeaders().get("webprotege_methodName");
        if (messageType == null) {
            String errorMessage = "webprotege_methodName header is missing.  Cannot process message.  Message reply topic: " + replyChannel;
            this.replyWithBadRequest(message, channel, errorMessage, correlationId);
            return;
        }
        logger.info("Received command {} from user {}", (Object)messageType, (Object)userId);
        Optional<CommandHandler> handler = this.extractHandler(messageType);
        if (handler.isEmpty()) {
            logger.warn("Command handler for message not found.  Message type: {}", (Object)messageType);
            String errorMessage = "Cannot find command handler for messages type " + messageType;
            CommandExecutionException ex = new CommandExecutionException(HttpStatus.INTERNAL_SERVER_ERROR, "", errorMessage);
            this.replyWithErrorResponse(message, channel, UserId.valueOf((String)userId), ex, correlationId);
        } else {
            this.parseAndHandleRequest(handler.get(), message, channel, UserId.valueOf((String)userId), accessToken, correlationId);
        }
    }

    private void replyWithBadRequest(Message message, Channel channel, String errorMessage, String correlationId) {
        logger.error("Replying to message with 400 (BAD REQUEST): {}", (Object)errorMessage);
        this.replyWithErrorResponse(message, channel, null, CommandExecutionException.of(HttpStatus.BAD_REQUEST, errorMessage), correlationId);
    }

    private void parseAndHandleRequest(CommandHandler<Q, R> handler, Message message, Channel channel, UserId userId, String accessToken, String correlationId) {
        try {
            Request request = (Request)this.objectMapper.readValue(message.getBody(), handler.getRequestClass());
            if (handler instanceof AuthorizedCommandHandler) {
                AuthorizedCommandHandler authorizedCommandHandler = (AuthorizedCommandHandler)handler;
                this.authorizeAndReplyToRequest(handler, message, channel, userId, request, authorizedCommandHandler, accessToken, correlationId);
            } else {
                this.handleAndReplyToRequest(handler, channel, message, userId, request, accessToken, correlationId);
            }
        }
        catch (StreamReadException | DatabindException e) {
            logger.error("Could not parse request.  Request: {}.  Error: {}", new Object[]{message.getBody(), e.getMessage(), e});
            String msg = "Could not parse request: " + e.getMessage();
            this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(e, HttpStatus.BAD_REQUEST, msg), correlationId);
        }
        catch (IOException e) {
            logger.error("Could not read message.  Request: {}.  Error: {}", new Object[]{message.getBody(), e.getMessage(), e});
            String msg = "Could not read request message: " + e.getMessage();
            this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(e, HttpStatus.INTERNAL_SERVER_ERROR, msg), correlationId);
        }
    }

    private Optional<CommandHandler> extractHandler(String messageType) {
        return this.handlers.stream().filter(handler -> handler.getChannelName().equalsIgnoreCase(messageType)).map(h -> h).findFirst();
    }

    private void authorizeAndReplyToRequest(CommandHandler<Q, R> handler, Message message, Channel channel, UserId userId, Q request, AuthorizedCommandHandler<Q, R> authenticatingCommandHandler, String accessToken, String correlationId) {
        Resource resource = authenticatingCommandHandler.getTargetResource(request);
        Subject subject = Subject.forUser((UserId)userId);
        Collection<Capability> requiredCapabilities = authenticatingCommandHandler.getRequiredCapabilities();
        GetAuthorizationStatusRequest authRequest = new GetAuthorizationStatusRequest(resource, subject, (Capability)requiredCapabilities.stream().findFirst().orElse(null));
        ExecutionContext executionContext = new ExecutionContext(userId, accessToken, correlationId);
        CompletableFuture<GetAuthorizationStatusResponse> authResponseFuture = this.authorizationStatusExecutor.execute(authRequest, executionContext);
        authResponseFuture.whenComplete((authResponse, authError) -> {
            if (authError != null) {
                logger.warn("Error requesting the authorization status for {} on {}. Error: {}", new Object[]{userId, resource, authError.getMessage()});
                this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(authError), correlationId);
            } else if (authResponse.authorizationStatus() == AuthorizationStatus.AUTHORIZED) {
                this.handleAndReplyToRequest(handler, channel, message, userId, request, accessToken, correlationId);
            } else {
                logger.info("Permission denied when attempting to execute a request.  User: {}, Request: {}", (Object)userId, (Object)request);
                String msg = "Permission denied for " + String.valueOf(request) + " on " + String.valueOf(resource);
                this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(HttpStatus.FORBIDDEN, msg), correlationId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAndReplyToRequest(CommandHandler<Q, R> handler, Channel channel, Message message, UserId userId, Q request, String accessToken, String correlationId) {
        ExecutionContext executionContext = new ExecutionContext(userId, accessToken, correlationId);
        long startTime = System.currentTimeMillis();
        try {
            Mono<R> response = handler.handleRequest(request, executionContext);
            response.subscribe(r -> {
                long endTime = System.currentTimeMillis();
                logger.info("Request executed {}. Time taken for Execution is : {}ms", (Object)request.getChannel(), (Object)(endTime - startTime));
                this.replyWithSuccessResponse(channel, message, userId, r, correlationId);
            }, throwable -> {
                long endTime = System.currentTimeMillis();
                CommandExecutionException ex = CommandExecutionException.of(throwable);
                logger.info("Request failed {} with error {}. Time taken for Execution is : {}ms", new Object[]{request.getChannel(), throwable.getMessage(), endTime - startTime});
                this.replyWithErrorResponse(message, channel, userId, ex, correlationId);
            });
        }
        catch (Throwable throwable2) {
            long endTime = System.currentTimeMillis();
            logger.info("Request failed {} with error {}. Time taken for Execution is : {}ms", new Object[]{request.getChannel(), throwable2.getMessage(), endTime - startTime});
            this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(throwable2), correlationId);
        }
        finally {
            CorrelationMDCUtil.clearCorrelationId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyWithErrorResponse(Message message, Channel channel, @Nullable UserId userId, CommandExecutionException executionException, String correlationId) {
        try {
            String value = this.serializeCommandExecutionException(executionException);
            HashMap<String, String> headersMap = new HashMap<String, String>();
            headersMap.put("webprotege_error", String.valueOf(value));
            headersMap.put("webprotege_correlationId", correlationId);
            if (userId != null) {
                headersMap.put("webprotege_userId", String.valueOf(userId.id()));
            }
            headersMap.put("webprotege_serviceName", this.applicationName);
            AMQP.BasicProperties replyProps = new AMQP.BasicProperties.Builder().correlationId(message.getMessageProperties().getCorrelationId()).headers(headersMap).build();
            channel.basicPublish("webprotege-exchange", message.getMessageProperties().getReplyTo(), replyProps, value.getBytes());
        }
        catch (Exception e) {
            logger.error("Error publishing response ", (Throwable)e);
        }
        finally {
            CorrelationMDCUtil.clearCorrelationId();
        }
    }

    private void replyWithSuccessResponse(Channel channel, Message message, UserId userId, R response, String correlationId) {
        try {
            byte[] value = this.objectMapper.writeValueAsBytes(response);
            HashMap<String, String> headersMap = new HashMap<String, String>();
            headersMap.put("webprotege_serviceName", this.applicationName);
            AMQP.BasicProperties replyProps = new AMQP.BasicProperties.Builder().correlationId(message.getMessageProperties().getCorrelationId()).headers(headersMap).build();
            channel.basicPublish("webprotege-exchange", message.getMessageProperties().getReplyTo(), replyProps, value);
        }
        catch (JsonProcessingException e) {
            logger.error("Error serializing response.  Response: {}.  Error: {}", new Object[]{response, e.getMessage(), e});
            String msg = "Could not serialize response: " + e.getMessage();
            this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(e, HttpStatus.INTERNAL_SERVER_ERROR, msg), correlationId);
        }
        catch (IOException e) {
            logger.error("Error creating and sending response.  Response: {}.  Error: {}", new Object[]{response, e.getMessage(), e});
            String msg = "Error creating and sending response: " + e.getMessage();
            this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(e, HttpStatus.INTERNAL_SERVER_ERROR, msg), correlationId);
        }
        catch (Throwable e) {
            logger.error("Error handling replyWithSuccessResponse ", e);
            this.replyWithErrorResponse(message, channel, userId, CommandExecutionException.of(e), correlationId);
        }
    }

    private String serializeCommandExecutionException(CommandExecutionException exception) {
        try {
            return this.objectMapper.writeValueAsString((Object)exception);
        }
        catch (JsonProcessingException e) {
            logger.error("Error while serializing CommandExecutionException", (Throwable)e);
            return "{\n    \"statusCode\" : 500,\n    \"causeMessage\" : \"%s\",\n    \"causeClassName\" \"com.fasterxml.jackson.core.JsonProcessingException\"\n}\n".formatted(e.getMessage()).strip();
        }
    }
}

