/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.semanticweb.owlapi.model.EntityType;

public class EntityTypeDeserializer
extends StdDeserializer<EntityType<?>> {
    public EntityTypeDeserializer() {
        super(EntityType.class);
    }

    public EntityType<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String typeName = jsonParser.getValueAsString();
        if (EntityTypeDeserializer.isEntityType(typeName, EntityType.CLASS)) {
            return EntityType.CLASS;
        }
        if (EntityTypeDeserializer.isEntityType(typeName, EntityType.OBJECT_PROPERTY)) {
            return EntityType.OBJECT_PROPERTY;
        }
        if (EntityTypeDeserializer.isEntityType(typeName, EntityType.DATA_PROPERTY)) {
            return EntityType.DATA_PROPERTY;
        }
        if (EntityTypeDeserializer.isEntityType(typeName, EntityType.ANNOTATION_PROPERTY)) {
            return EntityType.ANNOTATION_PROPERTY;
        }
        if (EntityTypeDeserializer.isEntityType(typeName, EntityType.NAMED_INDIVIDUAL)) {
            return EntityType.NAMED_INDIVIDUAL;
        }
        if (EntityTypeDeserializer.isEntityType(typeName, EntityType.DATATYPE)) {
            return EntityType.DATATYPE;
        }
        throw new IOException("Unrecognized term type name: " + typeName);
    }

    private static boolean isEntityType(String typeName, EntityType<?> entityType) {
        return entityType.getPrefixedName().equals(typeName) || entityType.getName().equals(typeName);
    }
}

