/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.databind.util.StdConverter;
import edu.stanford.protege.webprotege.jackson.OWLAnnotationValueProxy;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDatatype;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;

public class OWLAnnotationValueDeserializationConverter
extends StdConverter<OWLAnnotationValueProxy, OWLAnnotationValue> {
    public OWLAnnotationValue convert(OWLAnnotationValueProxy value) {
        if (value.iri() != null) {
            return IRI.create((String)value.iri());
        }
        if (value.nodeId() != null) {
            return new OWLAnonymousIndividualImpl(NodeID.getNodeID((String)value.nodeId()));
        }
        if (value.value() != null) {
            OWLDatatypeImpl datatype = null;
            if (value.datatype() != null) {
                datatype = new OWLDatatypeImpl(IRI.create((String)value.datatype()));
            }
            return new OWLLiteralImpl(value.value(), value.lang(), (OWLDatatype)datatype);
        }
        throw new RuntimeException("Expected iri, nodeId or value");
    }
}

