/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.jackson.IriDeserializer;
import edu.stanford.protege.webprotege.jackson.OWLLiteralDeserializer;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;

public class OWLAnnotationValueDeserializer
extends StdDeserializer<OWLAnnotationValue> {
    @Nonnull
    private final OWLLiteralDeserializer literalDeserializer;
    @Nonnull
    private final IriDeserializer iriDeserializer;

    @Inject
    public OWLAnnotationValueDeserializer(@Nonnull OWLLiteralDeserializer literalDeserializer, @Nonnull IriDeserializer iriDeserializer) {
        super(OWLAnnotationValue.class);
        this.literalDeserializer = (OWLLiteralDeserializer)((Object)Preconditions.checkNotNull((Object)((Object)literalDeserializer)));
        this.iriDeserializer = (IriDeserializer)((Object)Preconditions.checkNotNull((Object)((Object)iriDeserializer)));
    }

    public OWLAnnotationValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.START_OBJECT)) {
            return this.literalDeserializer.deserialize(p, ctxt);
        }
        return this.iriDeserializer.deserialize(p, ctxt);
    }
}

