/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.databind.util.StdConverter;
import edu.stanford.protege.webprotege.jackson.OWLAnnotationValueProxy;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;

public class OWLAnnotationValueSerializationConverter
extends StdConverter<OWLAnnotationValue, OWLAnnotationValueProxy> {
    public OWLAnnotationValueProxy convert(OWLAnnotationValue value) {
        return (OWLAnnotationValueProxy)value.accept((OWLAnnotationValueVisitorEx)new OWLAnnotationValueVisitorEx<OWLAnnotationValueProxy>(){

            @Nonnull
            public OWLAnnotationValueProxy visit(@Nonnull IRI iri) {
                return new OWLAnnotationValueProxy(iri.toString(), null, null, null, null);
            }

            @Nonnull
            public OWLAnnotationValueProxy visit(@Nonnull OWLAnonymousIndividual individual) {
                return new OWLAnnotationValueProxy(null, individual.getID().getID(), null, null, null);
            }

            @Nonnull
            public OWLAnnotationValueProxy visit(@Nonnull OWLLiteral literal) {
                String datatypeString = null;
                if (!literal.isRDFPlainLiteral()) {
                    datatypeString = literal.getDatatype().getIRI().toString();
                }
                return new OWLAnnotationValueProxy(null, null, literal.getLiteral(), literal.getLang(), datatypeString);
            }
        });
    }
}

