/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;

public class OWLEntityDeserializer<E extends OWLEntity>
extends StdDeserializer<E> {
    private static final String TYPE_FIELD_LEGACY_NAME = "type";
    private static ImmutableMap<String, EntityType<?>> entityTypeMap = OWLEntityDeserializer.buildTypeMap();
    @Nonnull
    private final OWLDataFactory dataFactory;
    private final EntityType<?> defaultEntityType;

    private static ImmutableMap<String, EntityType<?>> buildTypeMap() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (EntityType entityType : EntityType.values()) {
            mapBuilder.put((Object)entityType.getName(), (Object)entityType);
            mapBuilder.put((Object)entityType.getPrefixedName(), (Object)entityType);
        }
        return mapBuilder.build();
    }

    public OWLEntityDeserializer(@Nonnull OWLDataFactory dataFactory) {
        this(dataFactory, null);
    }

    public OWLEntityDeserializer(@Nonnull OWLDataFactory dataFactory, EntityType<?> defaultEntityType) {
        super(OWLEntity.class);
        this.dataFactory = dataFactory;
        this.defaultEntityType = defaultEntityType;
    }

    public E deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(jsonParser, (EntityType)null);
    }

    public E deserialize(JsonParser jsonParser, EntityType<?> entityType) throws IOException {
        TreeNode tree = jsonParser.readValueAsTree();
        Object type = entityType;
        String iri = null;
        if (tree.isObject()) {
            ObjectNode objectNode = (ObjectNode)tree;
            iri = objectNode.get("iri").asText();
            JsonNode typeValue = objectNode.get("@type");
            if (typeValue == null) {
                typeValue = objectNode.get(TYPE_FIELD_LEGACY_NAME);
            }
            type = typeValue != null ? (EntityType)entityTypeMap.get((Object)typeValue.textValue()) : this.defaultEntityType;
        } else if (tree.isValueNode()) {
            ValueNode valueNode = (ValueNode)tree;
            iri = valueNode.textValue();
            type = this.defaultEntityType;
        }
        if (iri != null && type != null) {
            return (E)this.dataFactory.getOWLEntity(type, IRI.create((String)iri));
        }
        if (type == null) {
            throw new JsonParseException(jsonParser, "@type field is missing");
        }
        throw new JsonParseException(jsonParser, "iri field is missing");
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, (EntityType)null);
    }
}

