/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;

public class OWLLiteralDeserializer
extends StdDeserializer<OWLLiteral> {
    @Nonnull
    private final OWLDataFactory dataFactory;

    public OWLLiteralDeserializer(@Nonnull OWLDataFactory dataFactory) {
        super(OWLLiteral.class);
        this.dataFactory = dataFactory;
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }

    public OWLLiteral deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectNode tree = (ObjectNode)jsonParser.readValueAsTree();
        JsonNode value = tree.get("value");
        JsonNode lang = tree.get("lang");
        JsonNode iri = tree.get("datatype");
        if (iri == null) {
            iri = tree.get("type");
        }
        if (value == null) {
            throw new JsonParseException(jsonParser, "value field is missing");
        }
        if (lang != null) {
            return this.dataFactory.getOWLLiteral(value.asText(), lang.textValue());
        }
        if (iri != null) {
            return this.dataFactory.getOWLLiteral(value.asText(), this.dataFactory.getOWLDatatype(IRI.create((String)iri.textValue())));
        }
        return this.dataFactory.getOWLLiteral(value.asText(), "");
    }
}

