/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.semanticweb.owlapi.model.OWLLiteral;

public class OWLLiteralSerializer
extends StdSerializer<OWLLiteral> {
    public OWLLiteralSerializer() {
        super(OWLLiteral.class);
    }

    public void serialize(OWLLiteral value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        if (value.isRDFPlainLiteral()) {
            gen.writeFieldName("lang");
            gen.writeString(value.getLang());
        } else {
            gen.writeFieldName("datatype");
            gen.writeObject((Object)value.getDatatype().getIRI());
        }
        gen.writeFieldName("value");
        gen.writeObject((Object)value.getLiteral());
        gen.writeEndObject();
    }

    public void serializeWithType(OWLLiteral value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }
}

