/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OWLOntologyIDDeserializer
extends StdDeserializer<OWLOntologyID> {
    public OWLOntologyIDDeserializer() {
        super(OWLOntologyID.class);
    }

    public OWLOntologyID deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        String ontologyIri = null;
        String versionIri = null;
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jsonParser.getCurrentName();
            if ("ontologyIri".equals(fieldname)) {
                jsonParser.nextToken();
                ontologyIri = (String)jsonParser.readValueAs(String.class);
                continue;
            }
            if (!"versionIri".equals(fieldname)) continue;
            jsonParser.nextToken();
            versionIri = (String)jsonParser.readValueAs(String.class);
        }
        if (ontologyIri != null) {
            if (versionIri != null) {
                return new OWLOntologyID(IRI.create(ontologyIri), IRI.create(versionIri));
            }
            return new OWLOntologyID(IRI.create(ontologyIri));
        }
        return new OWLOntologyID();
    }
}

