/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Optional;
import java.io.IOException;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OWLOntologyIDSerializer
extends StdSerializer<OWLOntologyID> {
    @Inject
    public OWLOntologyIDSerializer() {
        super(OWLOntologyID.class);
    }

    public void serialize(OWLOntologyID value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Optional versionIri;
        gen.writeStartObject();
        Optional ontologyIri = value.getOntologyIRI();
        if (ontologyIri.isPresent()) {
            gen.writeStringField("ontologyIri", ((IRI)ontologyIri.get()).toString());
        }
        if ((versionIri = value.getVersionIRI()).isPresent()) {
            gen.writeStringField("versionIri", ((IRI)versionIri.get()).toString());
        }
        gen.writeEndObject();
    }
}

