/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.change.AddAxiomChange;
import edu.stanford.protege.webprotege.change.OntologyChange;
import edu.stanford.protege.webprotege.change.RemoveAxiomChange;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyChangeList<R> {
    @Nonnull
    private final R result;
    @Nonnull
    private final List<OntologyChange> changes;

    private OntologyChangeList(@Nonnull List<OntologyChange> changes, @Nonnull R result) {
        this.result = Preconditions.checkNotNull(result);
        this.changes = ImmutableList.copyOf(changes);
    }

    @Nonnull
    public List<OntologyChange> getChanges() {
        return this.changes;
    }

    @Nonnull
    public R getResult() {
        return this.result;
    }

    public static <R> Builder<R> builder() {
        return new Builder();
    }

    public static class Builder<R> {
        private final ImmutableList.Builder<OntologyChange> listBuilder = ImmutableList.builder();

        public void add(@Nonnull OntologyChange change) {
            this.listBuilder.add((Object)((OntologyChange)Preconditions.checkNotNull((Object)change)));
        }

        public boolean isEmpty() {
            return this.listBuilder.build().isEmpty();
        }

        public void addAxiom(@Nonnull OWLOntologyID ontologyId, @Nonnull OWLAxiom axiom) {
            this.add(AddAxiomChange.of((OWLOntologyID)Preconditions.checkNotNull((Object)ontologyId), (OWLAxiom)Preconditions.checkNotNull((Object)axiom)));
        }

        public void removeAxiom(@Nonnull OWLOntologyID ontologyId, @Nonnull OWLAxiom axiom) {
            this.add(RemoveAxiomChange.of((OWLOntologyID)Preconditions.checkNotNull((Object)ontologyId), (OWLAxiom)Preconditions.checkNotNull((Object)axiom)));
        }

        public Builder<R> addAll(@Nonnull List<? extends OntologyChange> changes) {
            this.listBuilder.addAll((Iterable)Preconditions.checkNotNull(changes));
            return this;
        }

        public OntologyChangeList<R> build(@Nonnull R subject) {
            return new OntologyChangeList<Object>((List<OntologyChange>)this.listBuilder.build(), Preconditions.checkNotNull(subject));
        }
    }
}

