/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.revision.TimestampSerializer;
import java.util.List;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;

@JsonPropertyOrder(value={"rev", "timestamp", "userId", "msg", "subjects", "changes"})
public class RevisionDetails {
    private final long revisionNumber;
    private final long timestamp;
    private final UserId userId;
    private final String msg;
    private final ImmutableCollection<IRI> subjects;
    private final ImmutableList<ChangeDetails> changeDetails;

    public RevisionDetails(int revisionNumber, long timestamp, UserId userId, String msg, ImmutableCollection<IRI> subjects, ImmutableList<ChangeDetails> changeDetails) {
        this.revisionNumber = revisionNumber;
        this.timestamp = timestamp;
        this.userId = userId;
        this.msg = msg;
        this.subjects = subjects;
        this.changeDetails = changeDetails;
    }

    @JsonProperty(value="rev")
    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    @JsonSerialize(using=TimestampSerializer.class)
    public long getTimestamp() {
        return this.timestamp;
    }

    public UserId getUserId() {
        return this.userId;
    }

    public String getMsg() {
        return this.msg;
    }

    public ImmutableCollection<IRI> getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="changes")
    public List<ChangeDetails> getChangeDetails() {
        return this.changeDetails;
    }

    public static class ChangeDetails {
        private final ChangeOperation operation;
        private final OWLAxiom axiom;

        public ChangeDetails(ChangeOperation operation, OWLAxiom axiom) {
            this.operation = operation;
            this.axiom = axiom;
        }

        public ChangeOperation getOperation() {
            return this.operation;
        }

        @JsonSerialize(using=ToStringSerializer.class)
        public OWLAxiom getAxiom() {
            return this.axiom;
        }
    }

    public static enum ChangeOperation {
        ADD,
        REMOVE;

    }
}

