/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class RevisionNumber
implements Serializable,
Comparable<RevisionNumber> {
    private static final long HEAD = Long.MAX_VALUE;
    private static final RevisionNumber HEAD_REVISION_NUMBER = new RevisionNumber(Long.MAX_VALUE);
    private long value;

    private RevisionNumber() {
    }

    private RevisionNumber(long value) {
        this.value = value;
    }

    public static RevisionNumber getHeadRevisionNumber() {
        return HEAD_REVISION_NUMBER;
    }

    @JsonCreator
    public static RevisionNumber getRevisionNumber(long revisionNumber) {
        if (revisionNumber == Long.MAX_VALUE) {
            return HEAD_REVISION_NUMBER;
        }
        return new RevisionNumber(revisionNumber);
    }

    @Nonnull
    public static RevisionNumber valueOf(String revisionNumber) {
        if ("HEAD".equalsIgnoreCase(revisionNumber)) {
            return RevisionNumber.getHeadRevisionNumber();
        }
        return RevisionNumber.getRevisionNumber(Long.parseLong(revisionNumber));
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    public int getValueAsInt() {
        if (this.value == Long.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.value;
    }

    public boolean isHead() {
        return this.value == Long.MAX_VALUE;
    }

    public RevisionNumber getNextRevisionNumber() {
        return RevisionNumber.getRevisionNumber(this.value + 1L);
    }

    public int hashCode() {
        return "RevisionNumber".hashCode() + (int)this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevisionNumber)) {
            return false;
        }
        RevisionNumber other = (RevisionNumber)obj;
        return this.value == other.value;
    }

    @Override
    public int compareTo(RevisionNumber o) {
        if (this.value < o.value) {
            return -1;
        }
        if (this.value > o.value) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RevisionNumber(");
        if (this.isHead()) {
            sb.append("HEAD");
        } else {
            sb.append("REV=");
            sb.append(this.value);
        }
        sb.append(")");
        return sb.toString();
    }
}

