/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.revision.ProjectDirectoryFactory;
import java.io.File;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class ChangeHistoryFileFactory {
    private static final String CHANGE_DATA_DIRECTORY_NAME = "change-data";
    private static final String CHANGE_DATA_FILE_NAME = "change-data.binary";
    @Nonnull
    private final ProjectDirectoryFactory projectDirectoryFactory;

    @Inject
    public ChangeHistoryFileFactory(@Nonnull ProjectDirectoryFactory projectDirectoryFactory) {
        this.projectDirectoryFactory = (ProjectDirectoryFactory)Preconditions.checkNotNull((Object)projectDirectoryFactory);
    }

    public File getChangeHistoryFile(@Nonnull ProjectId projectId) {
        Preconditions.checkNotNull((Object)projectId);
        File projectDirectory = this.projectDirectoryFactory.getProjectDirectory(projectId);
        return new File(new File(projectDirectory, CHANGE_DATA_DIRECTORY_NAME), CHANGE_DATA_FILE_NAME);
    }
}

