/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import edu.stanford.protege.webprotege.change.AddAxiomChange;
import edu.stanford.protege.webprotege.change.AddImportChange;
import edu.stanford.protege.webprotege.change.AddOntologyAnnotationChange;
import edu.stanford.protege.webprotege.change.OntologyChange;
import edu.stanford.protege.webprotege.change.RemoveAxiomChange;
import edu.stanford.protege.webprotege.change.RemoveImportChange;
import edu.stanford.protege.webprotege.change.RemoveOntologyAnnotationChange;
import edu.stanford.protege.webprotege.revision.OntologyChangeRecordTranslator;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.change.AddAxiomData;
import org.semanticweb.owlapi.change.AddImportData;
import org.semanticweb.owlapi.change.AddOntologyAnnotationData;
import org.semanticweb.owlapi.change.OWLOntologyChangeDataVisitor;
import org.semanticweb.owlapi.change.OWLOntologyChangeRecord;
import org.semanticweb.owlapi.change.RemoveAxiomData;
import org.semanticweb.owlapi.change.RemoveImportData;
import org.semanticweb.owlapi.change.RemoveOntologyAnnotationData;
import org.semanticweb.owlapi.change.SetOntologyIDData;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyChangeRecordTranslatorImpl
implements OntologyChangeRecordTranslator {
    @Inject
    public OntologyChangeRecordTranslatorImpl() {
    }

    @Override
    @Nonnull
    public OntologyChange getOntologyChange(@Nonnull OWLOntologyChangeRecord record) {
        final OWLOntologyID ontologyId = record.getOntologyID();
        OWLOntologyChangeDataVisitor<OntologyChange, RuntimeException> visitor = new OWLOntologyChangeDataVisitor<OntologyChange, RuntimeException>(){

            @Nonnull
            public OntologyChange visit(AddAxiomData data) throws RuntimeException {
                return OntologyChangeRecordTranslatorImpl.this.translateAddAxiom(data, ontologyId);
            }

            public OntologyChange visit(RemoveAxiomData data) throws RuntimeException {
                return OntologyChangeRecordTranslatorImpl.this.translateRemoveAxiom(data, ontologyId);
            }

            public OntologyChange visit(AddOntologyAnnotationData data) throws RuntimeException {
                return OntologyChangeRecordTranslatorImpl.this.translateAddOntologyAnnotation(data, ontologyId);
            }

            public OntologyChange visit(RemoveOntologyAnnotationData data) throws RuntimeException {
                return OntologyChangeRecordTranslatorImpl.this.translateRemoveOntologyAnnotation(data, ontologyId);
            }

            public OntologyChange visit(SetOntologyIDData data) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            public OntologyChange visit(AddImportData data) throws RuntimeException {
                return OntologyChangeRecordTranslatorImpl.this.translateAddImport(data, ontologyId);
            }

            public OntologyChange visit(RemoveImportData data) throws RuntimeException {
                return OntologyChangeRecordTranslatorImpl.this.translateRemoveImport(data, ontologyId);
            }
        };
        return (OntologyChange)record.getData().accept((OWLOntologyChangeDataVisitor)visitor);
    }

    private AddAxiomChange translateAddAxiom(AddAxiomData data, OWLOntologyID ontologyId) {
        return AddAxiomChange.of((OWLOntologyID)ontologyId, (OWLAxiom)data.getAxiom());
    }

    private RemoveAxiomChange translateRemoveAxiom(RemoveAxiomData data, OWLOntologyID ontologyId) {
        return RemoveAxiomChange.of((OWLOntologyID)ontologyId, (OWLAxiom)data.getAxiom());
    }

    private AddOntologyAnnotationChange translateAddOntologyAnnotation(AddOntologyAnnotationData data, OWLOntologyID ontologyId) {
        return AddOntologyAnnotationChange.of((OWLOntologyID)ontologyId, (OWLAnnotation)data.getAnnotation());
    }

    private RemoveOntologyAnnotationChange translateRemoveOntologyAnnotation(RemoveOntologyAnnotationData data, OWLOntologyID ontologyId) {
        return RemoveOntologyAnnotationChange.of((OWLOntologyID)ontologyId, (OWLAnnotation)data.getAnnotation());
    }

    private AddImportChange translateAddImport(AddImportData data, OWLOntologyID ontologyId) {
        return AddImportChange.of((OWLOntologyID)ontologyId, (OWLImportsDeclaration)data.getDeclaration());
    }

    private RemoveImportChange translateRemoveImport(RemoveImportData data, OWLOntologyID ontologyId) {
        return RemoveImportChange.of((OWLOntologyID)ontologyId, (OWLImportsDeclaration)data.getDeclaration());
    }
}

