/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.change.OntologyChange;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.revision.RevisionNumber;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class Revision
implements Comparable<Revision> {
    private final UserId userId;
    private final RevisionNumber revisionNumber;
    private final long timestamp;
    private final ImmutableList<OntologyChange> changes;
    private final String highLevelDescription;

    public Revision(UserId userId, RevisionNumber revisionNumber, ImmutableList<OntologyChange> changes, long timestamp, String highLevelDescription) {
        this.changes = (ImmutableList)Preconditions.checkNotNull(changes);
        this.userId = (UserId)Preconditions.checkNotNull((Object)userId);
        this.revisionNumber = (RevisionNumber)Preconditions.checkNotNull((Object)revisionNumber);
        this.timestamp = timestamp;
        this.highLevelDescription = (String)Preconditions.checkNotNull((Object)highLevelDescription);
    }

    public int getSize() {
        return this.changes.size();
    }

    public ImmutableList<OntologyChange> getChanges() {
        return this.changes;
    }

    public static Revision createEmptyRevisionWithRevisionNumber(RevisionNumber revision) {
        return new Revision(UserId.getGuest(), revision, (ImmutableList<OntologyChange>)ImmutableList.of(), 0L, "");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UserId getUserId() {
        return this.userId;
    }

    public RevisionNumber getRevisionNumber() {
        return this.revisionNumber;
    }

    @Override
    public int compareTo(@Nonnull Revision o) {
        return this.revisionNumber.compareTo(o.revisionNumber);
    }

    public String getHighLevelDescription() {
        return this.highLevelDescription != null ? this.highLevelDescription : "";
    }

    @Nonnull
    public Iterator<OntologyChange> iterator() {
        return this.changes.iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Revision").addValue((Object)this.revisionNumber).addValue((Object)this.userId).add("timestamp", this.timestamp).add("description", (Object)this.highLevelDescription).add("changes", this.changes.size()).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)obj;
        return this.userId.equals((Object)other.userId) && this.revisionNumber.equals(other.revisionNumber) && this.timestamp == other.timestamp && this.highLevelDescription.equals(other.highLevelDescription) && this.changes.equals(other.changes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userId, this.revisionNumber, this.timestamp, this.highLevelDescription, this.changes});
    }
}

