/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.change.OntologyChange;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.revision.Revision;
import edu.stanford.protege.webprotege.revision.RevisionManager;
import edu.stanford.protege.webprotege.revision.RevisionNumber;
import edu.stanford.protege.webprotege.revision.RevisionStore;
import edu.stanford.protege.webprotege.revision.RevisionSummary;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class RevisionManagerImpl
implements RevisionManager {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final RevisionStore revisionStore;

    @Inject
    public RevisionManagerImpl(@Nonnull RevisionStore revisionStore) {
        this.revisionStore = (RevisionStore)Preconditions.checkNotNull((Object)revisionStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Revision addRevision(@Nonnull UserId userId, @Nonnull List<OntologyChange> changes, @Nonnull String desc) {
        try {
            this.writeLock.lock();
            long timestamp = System.currentTimeMillis();
            RevisionNumber revisionNumber = this.revisionStore.getCurrentRevisionNumber().getNextRevisionNumber();
            Revision revision = new Revision(userId, revisionNumber, (ImmutableList<OntologyChange>)ImmutableList.copyOf(changes), timestamp, desc);
            this.revisionStore.addRevision(revision);
            Revision revision2 = revision;
            return revision2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @Nonnull
    public RevisionNumber getCurrentRevision() {
        return this.revisionStore.getCurrentRevisionNumber();
    }

    @Override
    @Nonnull
    public OWLOntologyManager getOntologyManagerForRevision(@Nonnull RevisionNumber revision) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntologyID singletonOntologyId = new OWLOntologyID();
            for (Revision rev : this.revisionStore.getRevisions()) {
                if (rev.getRevisionNumber().compareTo(revision) > 0) continue;
                for (OntologyChange record : rev.getChanges()) {
                    OntologyChange normalisedChangeRecord = this.normaliseChangeRecord(record, singletonOntologyId);
                    OWLOntologyID ontologyId = normalisedChangeRecord.getOntologyId();
                    if (!manager.contains(ontologyId)) {
                        manager.createOntology(ontologyId);
                    }
                    OWLOntologyChange change = normalisedChangeRecord.toOwlOntologyChangeRecord().createOntologyChange(manager);
                    manager.applyChange(change);
                }
            }
            if (manager.getOntologies().isEmpty()) {
                manager.createOntology();
            }
            return manager;
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException("Problem creating ontology: " + e);
        }
    }

    private OntologyChange normaliseChangeRecord(@Nonnull OntologyChange change, @Nonnull OWLOntologyID singletonAnonymousId) {
        OWLOntologyID ontologyID = change.getOntologyId();
        if (ontologyID.isAnonymous()) {
            return change.replaceOntologyId(singletonAnonymousId);
        }
        return change;
    }

    @Override
    @Nonnull
    public ImmutableList<Revision> getRevisions() {
        return this.revisionStore.getRevisions();
    }

    @Override
    @Nonnull
    public Optional<Revision> getRevision(@Nonnull RevisionNumber revisionNumber) {
        return this.revisionStore.getRevision(revisionNumber);
    }

    @Override
    @Nonnull
    public Optional<RevisionSummary> getRevisionSummary(@Nonnull RevisionNumber revisionNumber) {
        Optional<Revision> revision = this.revisionStore.getRevision(revisionNumber);
        return revision.map(RevisionManagerImpl::toRevisionSummary);
    }

    private static RevisionSummary toRevisionSummary(Revision revision) {
        return new RevisionSummary(revision.getRevisionNumber(), revision.getUserId(), revision.getTimestamp(), revision.getSize(), revision.getHighLevelDescription());
    }

    @Override
    @Nonnull
    public List<RevisionSummary> getRevisionSummaries() {
        return this.revisionStore.getRevisions().stream().map(RevisionManagerImpl::toRevisionSummary).collect(Collectors.toList());
    }
}

