/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.change.OntologyChange;
import edu.stanford.protege.webprotege.revision.Revision;
import edu.stanford.protege.webprotege.revision.RevisionSerializationVocabulary;
import edu.stanford.protege.webprotege.revision.RevisionType;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLOntologyChangeLog;
import org.semanticweb.binaryowl.change.OntologyChangeRecordList;

public class RevisionSerializationTask
implements Callable<Integer> {
    private final File file;
    private final Revision revision;
    private Runnable savedHook = () -> {};

    public RevisionSerializationTask(File file, Revision revision) {
        this.file = file;
        this.revision = revision;
    }

    public void setSavedHook(Runnable savedHook) {
        this.savedHook = (Runnable)Preconditions.checkNotNull((Object)savedHook);
    }

    @Override
    public Integer call() throws IOException {
        BinaryOWLMetadata metadata = new BinaryOWLMetadata();
        metadata.setStringAttribute(RevisionSerializationVocabulary.USERNAME_METADATA_ATTRIBUTE.getVocabularyName(), this.revision.getUserId().id());
        metadata.setLongAttribute(RevisionSerializationVocabulary.REVISION_META_DATA_ATTRIBUTE.getVocabularyName(), this.revision.getRevisionNumber().getValue());
        metadata.setStringAttribute(RevisionSerializationVocabulary.DESCRIPTION_META_DATA_ATTRIBUTE.getVocabularyName(), this.revision.getHighLevelDescription());
        metadata.setStringAttribute(RevisionSerializationVocabulary.REVISION_TYPE_META_DATA_ATTRIBUTE.getVocabularyName(), RevisionType.EDIT.name());
        BinaryOWLOntologyChangeLog changeLog = new BinaryOWLOntologyChangeLog();
        ImmutableList changeRecords = (ImmutableList)this.revision.getChanges().stream().map(OntologyChange::toOwlOntologyChangeRecord).collect(ImmutableList.toImmutableList());
        changeLog.appendChanges(new OntologyChangeRecordList(this.revision.getTimestamp(), metadata, changeRecords), this.file);
        this.savedHook.run();
        return 0;
    }
}

