/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.revision.ChangeHistoryFileFactory;
import edu.stanford.protege.webprotege.revision.RevisionNumber;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.binaryowl.BinaryOWLChangeLogHandler;
import org.semanticweb.binaryowl.BinaryOWLOntologyChangeLog;
import org.semanticweb.binaryowl.change.OntologyChangeRecordList;
import org.semanticweb.binaryowl.chunk.SkipSetting;
import org.semanticweb.owlapi.model.OWLDataFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class HeadRevisionNumberFinder {
    @Nonnull
    private final ChangeHistoryFileFactory changeHistoryFileFactory;

    @Inject
    public HeadRevisionNumberFinder(@Nonnull ChangeHistoryFileFactory changeHistoryFileFactory) {
        this.changeHistoryFileFactory = (ChangeHistoryFileFactory)Preconditions.checkNotNull((Object)changeHistoryFileFactory);
    }

    @Nonnull
    public RevisionNumber getHeadRevisionNumber(@Nonnull ProjectId projectId) throws IOException {
        File changeHistoryFile = this.changeHistoryFileFactory.getChangeHistoryFile(projectId);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(changeHistoryFile.toPath(), new OpenOption[0]));){
            BinaryOWLOntologyChangeLog log = new BinaryOWLOntologyChangeLog();
            RevisionExtractor extractor = new RevisionExtractor();
            log.readChanges((InputStream)bufferedInputStream, (OWLDataFactory)new OWLDataFactoryImpl(), (BinaryOWLChangeLogHandler)extractor, SkipSetting.SKIP_DATA);
            RevisionNumber revisionNumber = RevisionNumber.getRevisionNumber(extractor.getLastRevision());
            return revisionNumber;
        }
    }

    private static class RevisionExtractor
    implements BinaryOWLChangeLogHandler {
        private int counter = 0;

        private RevisionExtractor() {
        }

        public void handleChangesRead(OntologyChangeRecordList list, SkipSetting skipSetting, long filePosition) {
            ++this.counter;
        }

        public int getLastRevision() {
            return this.counter;
        }
    }
}

