/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.revision.ChangeHistoryFileFactory;
import edu.stanford.protege.webprotege.revision.OntologyChangeRecordTranslator;
import edu.stanford.protege.webprotege.revision.RevisionStore;
import edu.stanford.protege.webprotege.revision.RevisionStoreImpl;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;

public class RevisionStoreFactory {
    @Nonnull
    private final ChangeHistoryFileFactory changeHistoryFileFactory;
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final OntologyChangeRecordTranslator changeRecordTranslator;

    @Inject
    public RevisionStoreFactory(@Nonnull ChangeHistoryFileFactory changeHistoryFileFactory, @Nonnull OWLDataFactory dataFactory, @Nonnull OntologyChangeRecordTranslator changeRecordTranslator) {
        this.changeHistoryFileFactory = (ChangeHistoryFileFactory)Preconditions.checkNotNull((Object)changeHistoryFileFactory);
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
        this.changeRecordTranslator = (OntologyChangeRecordTranslator)Preconditions.checkNotNull((Object)changeRecordTranslator);
    }

    @Nonnull
    public RevisionStore createRevisionStore(@Nonnull ProjectId projectId) {
        Preconditions.checkNotNull((Object)projectId);
        RevisionStoreImpl revisionStore = new RevisionStoreImpl(projectId, this.changeHistoryFileFactory, this.dataFactory, this.changeRecordTranslator);
        revisionStore.load();
        return revisionStore;
    }
}

