/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.stanford.protege.webprotege.change.OntologyChange;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.revision.ChangeHistoryFileFactory;
import edu.stanford.protege.webprotege.revision.OntologyChangeRecordTranslator;
import edu.stanford.protege.webprotege.revision.Revision;
import edu.stanford.protege.webprotege.revision.RevisionNumber;
import edu.stanford.protege.webprotege.revision.RevisionSerializationTask;
import edu.stanford.protege.webprotege.revision.RevisionSerializationVocabulary;
import edu.stanford.protege.webprotege.revision.RevisionStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLOntologyChangeLog;
import org.semanticweb.binaryowl.chunk.SkipSetting;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionStoreImpl
implements RevisionStore {
    private static final Logger logger = LoggerFactory.getLogger(RevisionStoreImpl.class);
    private final ExecutorService changeSerializationExecutor;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    @Nonnull
    private final ProjectId projectId;
    @Nonnull
    private final ChangeHistoryFileFactory changeHistoryFileFactory;
    @Nonnull
    private final OWLDataFactory dataFactory;
    private ImmutableList<Revision> revisions = ImmutableList.of();
    @Nonnull
    private final OntologyChangeRecordTranslator changeRecordTranslator;
    private Runnable savedHook = () -> {};
    private boolean loaded = false;

    @Inject
    public RevisionStoreImpl(@Nonnull ProjectId projectId, @Nonnull ChangeHistoryFileFactory changeHistoryFileFactory, @Nonnull OWLDataFactory dataFactory, @Nonnull OntologyChangeRecordTranslator changeRecordTranslator) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.changeHistoryFileFactory = changeHistoryFileFactory;
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
        this.changeRecordTranslator = changeRecordTranslator;
        this.changeSerializationExecutor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName(thread.getName().replace("thread", "change-serializer-thread"));
            return thread;
        });
    }

    public void setSavedHook(Runnable savedHook) {
        this.savedHook = (Runnable)Preconditions.checkNotNull((Object)savedHook);
    }

    @Override
    @Nonnull
    public Optional<Revision> getRevision(@Nonnull RevisionNumber revisionNumber) {
        if (this.revisions.isEmpty()) {
            return Optional.empty();
        }
        int index = this.getRevisionIndexForRevision(revisionNumber);
        if (index < 0 || this.revisions.size() <= index) {
            return Optional.empty();
        }
        return Optional.of((Revision)this.revisions.get(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRevisionIndexForRevision(RevisionNumber revision) {
        try {
            this.readLock.lock();
            if (this.revisions.isEmpty()) {
                int n = -1;
                return n;
            }
            if (revision.isHead()) {
                int n = this.revisions.size() - 1;
                return n;
            }
            Revision firstRevision = (Revision)this.revisions.get(0);
            if (revision.compareTo(firstRevision.getRevisionNumber()) < 0) {
                int n = -1;
                return n;
            }
            Revision lastRevision = (Revision)this.revisions.get(this.revisions.size() - 1);
            if (lastRevision.getRevisionNumber() == revision) {
                int n = this.revisions.size() - 1;
                return n;
            }
            Revision dummyRevision = Revision.createEmptyRevisionWithRevisionNumber(revision);
            int n = Collections.binarySearch(this.revisions, dummyRevision);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @Nonnull
    public ImmutableList<Revision> getRevisions() {
        try {
            this.readLock.lock();
            ImmutableList<Revision> immutableList = this.revisions;
            return immutableList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void addRevision(@Nonnull Revision revision) {
        Preconditions.checkNotNull((Object)revision);
        try {
            this.writeLock.lock();
            if (revision.getRevisionNumber().compareTo(this.getCurrentRevisionNumber()) <= 0) {
                throw new IllegalArgumentException(String.format("Revision number (%d) must be greater than the current revision number (%d)", revision.getRevisionNumber().getValue(), this.getCurrentRevisionNumber().getValue()));
            }
            ImmutableList.Builder extendedListBuilder = ImmutableList.builder();
            extendedListBuilder.addAll(this.revisions);
            extendedListBuilder.add((Object)revision);
            this.revisions = extendedListBuilder.build();
            this.persistChanges(revision);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @Nonnull
    public RevisionNumber getCurrentRevisionNumber() {
        try {
            this.readLock.lock();
            if (this.revisions.isEmpty()) {
                RevisionNumber revisionNumber = RevisionNumber.getRevisionNumber(0L);
                return revisionNumber;
            }
            RevisionNumber revisionNumber = ((Revision)this.revisions.get(this.revisions.size() - 1)).getRevisionNumber();
            return revisionNumber;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistChanges(Revision revision) {
        try {
            this.writeLock.lock();
            File changeHistoryFile = this.changeHistoryFileFactory.getChangeHistoryFile(this.projectId);
            RevisionSerializationTask revisionSerializationTask = new RevisionSerializationTask(changeHistoryFile, revision);
            revisionSerializationTask.setSavedHook(this.savedHook);
            if (this.revisions.size() != 1) {
                this.changeSerializationExecutor.submit(revisionSerializationTask);
            } else {
                try {
                    logger.info("{} Saving first revision of project", (Object)this.projectId);
                    revisionSerializationTask.call();
                }
                catch (IOException e) {
                    logger.error("{} An error occurred whilst saving the first revision of the project.  Cause: {}.", new Object[]{this.projectId, e.getMessage(), e});
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.writeLock.lock();
            if (this.loaded) {
                return;
            }
            File changeHistoryFile = this.changeHistoryFileFactory.getChangeHistoryFile(this.projectId);
            if (!changeHistoryFile.exists()) {
                changeHistoryFile.getParentFile().mkdirs();
                return;
            }
            ImmutableList.Builder revisionsBuilder = ImmutableList.builder();
            Interner metadataInterner = Interners.newStrongInterner();
            Interner userIdInterner = Interners.newStrongInterner();
            try {
                logger.info("{} Loading change history", (Object)this.projectId);
                Stopwatch stopwatch = Stopwatch.createStarted();
                BinaryOWLOntologyChangeLog changeLog = new BinaryOWLOntologyChangeLog();
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(changeHistoryFile));
                changeLog.readChanges((InputStream)inputStream, this.dataFactory, (changeRecordList, skipSetting, l) -> {
                    BinaryOWLMetadata metadata = changeRecordList.getMetadata();
                    String userName = (String)metadataInterner.intern((Object)metadata.getStringAttribute(RevisionSerializationVocabulary.USERNAME_METADATA_ATTRIBUTE.getVocabularyName(), ""));
                    Long revisionNumberValue = metadata.getLongAttribute(RevisionSerializationVocabulary.REVISION_META_DATA_ATTRIBUTE.getVocabularyName(), Long.valueOf(0L));
                    RevisionNumber revisionNumber = RevisionNumber.getRevisionNumber(revisionNumberValue);
                    String description = metadata.getStringAttribute(RevisionSerializationVocabulary.DESCRIPTION_META_DATA_ATTRIBUTE.getVocabularyName(), "");
                    UserId userId = (UserId)userIdInterner.intern((Object)UserId.valueOf((String)userName));
                    ImmutableList internedChangeRecords = (ImmutableList)changeRecordList.getChangeRecords().stream().map(this.changeRecordTranslator::getOntologyChange).collect(ImmutableList.toImmutableList());
                    Revision revision = new Revision(userId, revisionNumber, (ImmutableList<OntologyChange>)internedChangeRecords, changeRecordList.getTimestamp(), description);
                    revisionsBuilder.add((Object)revision);
                }, SkipSetting.SKIP_NONE);
                inputStream.close();
                stopwatch.stop();
                logger.info("{} Change history loading complete.  Loaded {} revisions in {} ms.", new Object[]{this.projectId, this.revisions.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            }
            catch (Exception e) {
                logger.error("{} Failed to load change history for project.  Cause: {}", new Object[]{this.projectId, e.getMessage(), e});
            }
            this.revisions = revisionsBuilder.build();
            this.loaded = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void dispose() {
        this.changeSerializationExecutor.shutdown();
    }
}

