/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineConverterBase;
import org.swrlapi.bridge.converters.TargetRuleEngineOWLIndividualConverter;

public class DroolsOWLIndividual2DRLConverter
extends TargetRuleEngineConverterBase
implements TargetRuleEngineOWLIndividualConverter<String> {
    public DroolsOWLIndividual2DRLConverter(@NonNull SWRLRuleEngineBridge bridge) {
        super(bridge);
    }

    public @NonNull String convert(@NonNull OWLIndividual individual) {
        if (individual.isNamed()) {
            IRI individualIRI = individual.asOWLNamedIndividual().getIRI();
            String prefixedName = this.iri2PrefixedName(individualIRI);
            return "new I(\"" + prefixedName + "\")";
        }
        String individualID = individual.asOWLAnonymousIndividual().getID().getID();
        return "new I(\"" + individualID + "\")";
    }
}

