/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineSQWRLQueryConverter;
import org.swrlapi.drools.converters.drl.DroolsDRLConverterBase;
import org.swrlapi.drools.converters.drl.DroolsSWRLBodyAtom2DRLConverter;
import org.swrlapi.drools.converters.drl.DroolsSWRLHeadAtom2DRLConverter;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.core.DroolsSWRLRuleEngine;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;
import org.swrlapi.sqwrl.SQWRLNames;
import org.swrlapi.sqwrl.SQWRLQuery;

public class DroolsSQWRLQuery2DRLConverter
extends DroolsDRLConverterBase
implements TargetRuleEngineSQWRLQueryConverter {
    private final @NonNull DroolsSWRLBodyAtom2DRLConverter bodyAtom2DRLConverter;
    private final @NonNull DroolsSWRLHeadAtom2DRLConverter headAtom2DRLConverter;
    private final @NonNull DroolsSWRLRuleEngine droolsEngine;

    public DroolsSQWRLQuery2DRLConverter(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsSWRLRuleEngine droolsEngine, @NonNull DroolsOWLClassExpressionHandler classExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler) {
        super(bridge);
        this.droolsEngine = droolsEngine;
        this.bodyAtom2DRLConverter = new DroolsSWRLBodyAtom2DRLConverter(bridge, classExpressionHandler, droolsOWLPropertyExpressionHandler, droolsOWLDataRangeHandler);
        this.headAtom2DRLConverter = new DroolsSWRLHeadAtom2DRLConverter(bridge, classExpressionHandler, droolsOWLPropertyExpressionHandler);
    }

    public void reset() {
        this.bodyAtom2DRLConverter.reset();
        this.headAtom2DRLConverter.reset();
    }

    public void convert(@NonNull SQWRLQuery query) throws TargetSWRLRuleEngineException, SWRLBuiltInException {
        this.getDroolsSWRLBodyAtom2DRLConverter().reset();
        this.getDroolsSWRLHeadAtom2DRLConverter().reset();
        this.sqwrlQuery2DRL(query);
    }

    private void sqwrlQuery2DRL(@NonNull SQWRLQuery query) throws TargetSWRLRuleEngineException, SWRLBuiltInException {
        if (!query.hasSQWRLCollections()) {
            this.sqwrlNonCollectionQuery2DRL(query);
        } else {
            this.sqwrlCollectionQuery2DRL(query);
        }
    }

    private void sqwrlNonCollectionQuery2DRL(@NonNull SQWRLQuery query) throws TargetSWRLRuleEngineException, SWRLBuiltInException {
        HashSet<@NonNull String> previouslyEncounteredVariableNames = new HashSet<String>();
        String ruleName = query.getQueryName();
        String drlRule = this.getQueryPreamble(ruleName);
        for (SWRLAtom atom : query.getBodyAtoms()) {
            drlRule = drlRule + "\n   " + this.getDroolsSWRLBodyAtom2DRLConverter().convert(atom, previouslyEncounteredVariableNames) + " ";
        }
        drlRule = this.addQueryThenClause(drlRule);
        for (SWRLAtom atom : query.getHeadAtoms()) {
            drlRule = drlRule + "\n   " + this.getDroolsSWRLHeadAtom2DRLConverter().convert(atom) + " ";
        }
        drlRule = this.addQueryEndClause(drlRule);
        this.getDroolsSWRLEngine().defineDRLSQWRLPhase1Rule(query.getQueryName(), ruleName, drlRule);
    }

    private void sqwrlCollectionQuery2DRL(@NonNull SQWRLQuery query) throws TargetSWRLRuleEngineException, SWRLBuiltInException {
        String collectionVariableName;
        HashSet<@NonNull String> previouslyEncounteredVariableNames = new HashSet<String>();
        String queryName = query.getQueryName();
        String phase1RuleName = queryName + "-makeCollection";
        String phase2RuleName = queryName + "-operateCollection";
        String drlPhase1Rule = this.getQueryPreamble(phase1RuleName);
        String drlPhase2Rule = this.getQueryPreamble(phase2RuleName);
        for (SWRLAtom atom : query.getSQWRLPhase1BodyAtoms()) {
            drlPhase1Rule = drlPhase1Rule + "\n  " + this.getDroolsSWRLBodyAtom2DRLConverter().convert(atom, previouslyEncounteredVariableNames) + " ";
        }
        drlPhase1Rule = this.addQueryThenClause(drlPhase1Rule);
        if (query.hasSQWRLCollections()) {
            try {
                for (SWRLAtom atom : query.getBuiltInAtomsFromBody(SQWRLNames.getCollectionMakeBuiltInNames())) {
                    collectionVariableName = atom.getArgumentVariableName(0);
                    drlPhase1Rule = drlPhase1Rule + "\n  sqwrlInferrer.infer(" + this.getDroolsSWRLVariable2NameConverter().variableName2DRL(collectionVariableName) + "); ";
                }
            }
            catch (RuntimeException e) {
                throw new TargetSWRLRuleEngineException("error processing SQWRL collection make in query " + queryName + ": " + (e.getMessage() != null ? e.getMessage() : ""), (Throwable)e);
            }
        }
        drlPhase1Rule = this.addQueryEndClause(drlPhase1Rule);
        this.getDroolsSWRLEngine().defineDRLSQWRLPhase1Rule(queryName, phase1RuleName, drlPhase1Rule);
        previouslyEncounteredVariableNames.clear();
        if (query.hasSQWRLCollections()) {
            try {
                for (SWRLAtom atom : query.getBuiltInAtomsFromBody(SQWRLNames.getCollectionMakeBuiltInNames())) {
                    collectionVariableName = atom.getArgumentVariableName(0);
                    if (previouslyEncounteredVariableNames.contains(collectionVariableName)) continue;
                    String collection = this.getDroolsSWRLVariable2NameConverter().variableName2DRL(collectionVariableName);
                    drlPhase2Rule = drlPhase2Rule + "\n " + collection + ":" + "SQWRLC" + "(" + "queryName" + "==\"" + queryName + "\", " + "collectionName" + "==\"" + collectionVariableName + "\")";
                    previouslyEncounteredVariableNames.add(collectionVariableName);
                }
            }
            catch (RuntimeException e) {
                throw new TargetSWRLRuleEngineException("error processing SQWRL collection operate in query " + queryName + ": " + (e.getMessage() != null ? e.getMessage() : ""), (Throwable)e);
            }
        }
        for (SWRLAtom atom : query.getSQWRLPhase2BodyAtoms()) {
            drlPhase2Rule = drlPhase2Rule + "\n  " + this.getDroolsSWRLBodyAtom2DRLConverter().convert(atom, previouslyEncounteredVariableNames) + " ";
        }
        drlPhase2Rule = this.addQueryThenClause(drlPhase2Rule);
        for (SWRLAtom atom : query.getHeadAtoms()) {
            drlPhase2Rule = drlPhase2Rule + "\n  " + this.getDroolsSWRLHeadAtom2DRLConverter().convert(atom);
        }
        drlPhase2Rule = this.addQueryEndClause(drlPhase2Rule);
        this.getDroolsSWRLEngine().defineDRLSQWRLPhase2Rule(queryName, phase2RuleName, drlPhase2Rule);
    }

    private @NonNull String getQueryPreamble(@NonNull String queryName) {
        return "rule \"" + queryName + "\" \nwhen ";
    }

    private @NonNull String addQueryEndClause(@NonNull String queryText) {
        return queryText + "\nend";
    }

    private @NonNull String addQueryThenClause(@NonNull String queryText) {
        return queryText + "\nthen ";
    }

    private @NonNull DroolsSWRLBodyAtom2DRLConverter getDroolsSWRLBodyAtom2DRLConverter() {
        return this.bodyAtom2DRLConverter;
    }

    private @NonNull DroolsSWRLHeadAtom2DRLConverter getDroolsSWRLHeadAtom2DRLConverter() {
        return this.headAtom2DRLConverter;
    }

    private @NonNull DroolsSWRLRuleEngine getDroolsSWRLEngine() {
        return this.droolsEngine;
    }
}

