/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineSWRLBodyAtomWithVariableNamesConverter;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.drools.converters.drl.DroolsDRLConverterBase;
import org.swrlapi.drools.converters.drl.DroolsOWLIndividual2DRLConverter;
import org.swrlapi.drools.converters.drl.DroolsOWLLiteral2DRLConverter;
import org.swrlapi.drools.converters.drl.DroolsSWRLBodyAtomArgument2DRLConverter;
import org.swrlapi.drools.converters.drl.DroolsSWRLBuiltInArgument2DRLConverter;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.id.DroolsOWLEntity2NameConverter;
import org.swrlapi.drools.converters.id.DroolsSWRLVariable2NameConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineNotImplementedFeatureException;

public class DroolsSWRLBodyAtom2DRLConverter
extends DroolsDRLConverterBase
implements TargetRuleEngineSWRLBodyAtomWithVariableNamesConverter<String> {
    private final @NonNull DroolsSWRLBodyAtomArgument2DRLConverter droolsBodyAtomArgument2DRLConverter;
    private final @NonNull DroolsSWRLBuiltInArgument2DRLConverter droolsBuiltInArgument2DRLConverter;
    private final @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;
    private final @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler;
    private final @NonNull DroolsSWRLVariable2NameConverter droolsSWRLVariable2NameConverter;
    private final @NonNull DroolsOWLLiteral2DRLConverter droolsOWLLiteral2DRLConverter;
    private final @NonNull DroolsOWLIndividual2DRLConverter droolsOWLIndividual2DRLConverter;
    private final @NonNull DroolsOWLEntity2NameConverter droolsOWLEntity2NameConverter;
    private int builtInIndexInBody;

    public DroolsSWRLBodyAtom2DRLConverter(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler) {
        super(bridge);
        this.droolsOWLClassExpressionHandler = droolsOWLClassExpressionHandler;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
        this.droolsOWLDataRangeHandler = droolsOWLDataRangeHandler;
        this.droolsBuiltInArgument2DRLConverter = new DroolsSWRLBuiltInArgument2DRLConverter(bridge, droolsOWLClassExpressionHandler, droolsOWLPropertyExpressionHandler);
        this.droolsSWRLVariable2NameConverter = new DroolsSWRLVariable2NameConverter(bridge);
        this.droolsOWLLiteral2DRLConverter = new DroolsOWLLiteral2DRLConverter(bridge);
        this.droolsOWLIndividual2DRLConverter = new DroolsOWLIndividual2DRLConverter(bridge);
        this.droolsOWLEntity2NameConverter = new DroolsOWLEntity2NameConverter(bridge);
        this.droolsBodyAtomArgument2DRLConverter = new DroolsSWRLBodyAtomArgument2DRLConverter(bridge, this.droolsSWRLVariable2NameConverter, this.droolsOWLLiteral2DRLConverter, this.droolsOWLIndividual2DRLConverter, this.droolsOWLEntity2NameConverter);
        this.builtInIndexInBody = 0;
    }

    public void reset() {
        this.builtInIndexInBody = 0;
    }

    public @NonNull String convert(@NonNull SWRLDataRangeAtom atom, Set<@NonNull String> previouslyEncounteredVariableNames) {
        String dataRangeID = this.getDroolsOWLDataRangeHandler().convert(atom.getPredicate());
        SWRLDArgument argument = (SWRLDArgument)atom.getArgument();
        throw new TargetSWRLRuleEngineNotImplementedFeatureException("data range atoms not implemented in rule head");
    }

    public @NonNull String convert(@NonNull SWRLDataRangeAtom atom) {
        String dataRangeID = this.getDroolsOWLDataRangeHandler().convert(atom.getPredicate());
        SWRLDArgument argument = (SWRLDArgument)atom.getArgument();
        throw new TargetSWRLRuleEngineNotImplementedFeatureException("data range atoms not implemented in rule head");
    }

    public @NonNull String convert(@NonNull SWRLClassAtom atom, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        String classID = this.getDroolsOWLClassExpressionHandler().convert(atom.getPredicate()).getceid();
        SWRLIArgument argument = (SWRLIArgument)atom.getArgument();
        String representation = "CAA(cid==" + this.addQuotes(classID) + ", ";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument, "i", previouslyEncounteredVariableNames);
        representation = representation + ")";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLObjectPropertyAtom atom, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(atom.getPredicate()).getid();
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLIArgument argument2 = (SWRLIArgument)atom.getSecondArgument();
        String representation = "OPAA(";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument1, "s", previouslyEncounteredVariableNames);
        representation = representation + ", pid==" + this.addQuotes(propertyID) + ", ";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument2, "o", previouslyEncounteredVariableNames);
        representation = representation + ")";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLDataPropertyAtom atom, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(atom.getPredicate()).getid();
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLDArgument argument2 = (SWRLDArgument)atom.getSecondArgument();
        String representation = "DPAA(";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument1, "s", previouslyEncounteredVariableNames);
        representation = representation + ", pid==" + this.addQuotes(propertyID) + ", ";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument2, "o", previouslyEncounteredVariableNames);
        representation = representation + ")";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLSameIndividualAtom atom, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLIArgument argument2 = (SWRLIArgument)atom.getSecondArgument();
        String representation = "SIA(";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument1, "i1", previouslyEncounteredVariableNames);
        representation = representation + ", ";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument2, "i2", previouslyEncounteredVariableNames);
        representation = representation + ")";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLDifferentIndividualsAtom atom, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLIArgument argument2 = (SWRLIArgument)atom.getSecondArgument();
        String representation = "DIA(";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument1, "i1", previouslyEncounteredVariableNames);
        representation = representation + ", ";
        representation = representation + this.getSWRLBodyAtomArgumentConverter().convert((SWRLArgument)argument2, "i2", previouslyEncounteredVariableNames);
        representation = representation + ")";
        return representation;
    }

    public String convert(@NonNull SWRLAPIBuiltInAtom builtInAtom, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) throws SWRLBuiltInException {
        String ruleName = builtInAtom.getRuleName();
        String builtInPrefixedName = builtInAtom.getBuiltInPrefixedName();
        boolean variableArgumentEncountered = false;
        String representation = "BAP(";
        int argumentNumber = 1;
        for (SWRLBuiltInArgument argument : builtInAtom.getBuiltInArguments()) {
            if (argument.isVariable()) {
                String variableName = this.getDroolsSWRLVariable2NameConverter().swrlVariable2VariableName((SWRLVariable)argument.asVariable());
                if (variableArgumentEncountered) {
                    representation = representation + ", ";
                }
                representation = representation + this.getDroolsSWRLVariable2NameConverter().variableName2DRL(variableName, "a" + argumentNumber, previouslyEncounteredVariableNames);
                variableArgumentEncountered = true;
            }
            if (++argumentNumber <= 11) continue;
            throw new TargetSWRLRuleEngineException("at most 11 built-in arguments currently supported");
        }
        representation = representation + ") from invoker.invoke(\"" + ruleName + "\", \"" + builtInPrefixedName + "\", " + this.builtInIndexInBody + ", false, ";
        if (builtInAtom.getPathVariableNames().size() > 10) {
            throw new TargetSWRLRuleEngineException("at most 10 built-in arguments supported");
        }
        boolean isFirst = true;
        representation = representation + "new VPATH(";
        for (String variableName : builtInAtom.getPathVariableNames()) {
            if (!isFirst) {
                representation = representation + ", ";
            }
            representation = representation + this.getDroolsSWRLVariable2NameConverter().variableName2DRL(variableName);
            isFirst = false;
        }
        representation = representation + "), ";
        if (builtInAtom.getNumberOfArguments() > 10) {
            throw new TargetSWRLRuleEngineException("at most 10 built-in arguments supported");
        }
        representation = representation + "new BAVNs(";
        isFirst = true;
        for (SWRLBuiltInArgument argument : builtInAtom.getBuiltInArguments()) {
            if (!isFirst) {
                representation = representation + ", ";
            }
            representation = argument.isVariable() ? representation + "\"" + this.getDroolsSWRLVariable2NameConverter().swrlVariable2VariableName((SWRLVariable)argument.asVariable()) + "\"" : representation + "\"\"";
            isFirst = false;
        }
        representation = representation + "), ";
        if (builtInAtom.getNumberOfArguments() > 11) {
            throw new TargetSWRLRuleEngineException("at most 11 allowed");
        }
        isFirst = true;
        for (SWRLBuiltInArgument argument : builtInAtom.getBuiltInArguments()) {
            if (!isFirst) {
                representation = representation + ", ";
            }
            representation = representation + this.getSWRLBuiltInArgumentConverter().convert(argument);
            isFirst = false;
        }
        representation = representation + ")";
        ++this.builtInIndexInBody;
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLAtom atom, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) throws SWRLBuiltInException {
        if (atom instanceof SWRLDataRangeAtom) {
            return this.convert((SWRLDataRangeAtom)atom, (Set)previouslyEncounteredVariableNames);
        }
        if (atom instanceof SWRLClassAtom) {
            return this.convert((SWRLClassAtom)atom, (Set)previouslyEncounteredVariableNames);
        }
        if (atom instanceof SWRLDataPropertyAtom) {
            return this.convert((SWRLDataPropertyAtom)atom, (Set)previouslyEncounteredVariableNames);
        }
        if (atom instanceof SWRLObjectPropertyAtom) {
            return this.convert((SWRLObjectPropertyAtom)atom, (Set)previouslyEncounteredVariableNames);
        }
        if (atom instanceof SWRLSameIndividualAtom) {
            return this.convert((SWRLSameIndividualAtom)atom, (Set)previouslyEncounteredVariableNames);
        }
        if (atom instanceof SWRLDifferentIndividualsAtom) {
            return this.convert((SWRLDifferentIndividualsAtom)atom, (Set)previouslyEncounteredVariableNames);
        }
        if (atom instanceof SWRLAPIBuiltInAtom) {
            return this.convert((SWRLAPIBuiltInAtom)atom, (Set)previouslyEncounteredVariableNames);
        }
        throw new TargetSWRLRuleEngineInternalException("unknown SWRL atom type " + atom.getClass().getCanonicalName());
    }

    private @NonNull DroolsSWRLBodyAtomArgument2DRLConverter getSWRLBodyAtomArgumentConverter() {
        return this.droolsBodyAtomArgument2DRLConverter;
    }

    private @NonNull DroolsSWRLBuiltInArgument2DRLConverter getSWRLBuiltInArgumentConverter() {
        return this.droolsBuiltInArgument2DRLConverter;
    }

    private @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }

    private @NonNull DroolsOWLClassExpressionHandler getDroolsOWLClassExpressionHandler() {
        return this.droolsOWLClassExpressionHandler;
    }

    private @NonNull DroolsOWLDataRangeHandler getDroolsOWLDataRangeHandler() {
        return this.droolsOWLDataRangeHandler;
    }

    private @NonNull String addQuotes(@NonNull String s) {
        return "\"" + s + "\"";
    }
}

