/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineSWRLBodyAtomArgumentWithVariableNamesConverter;
import org.swrlapi.bridge.extractors.TargetRuleEngineExtractorBase;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.drools.converters.drl.DroolsOWLIndividual2DRLConverter;
import org.swrlapi.drools.converters.drl.DroolsOWLLiteral2DRLConverter;
import org.swrlapi.drools.converters.id.DroolsOWLEntity2NameConverter;
import org.swrlapi.drools.converters.id.DroolsSWRLVariable2NameConverter;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;

public class DroolsSWRLBodyAtomArgument2DRLConverter
extends TargetRuleEngineExtractorBase
implements TargetRuleEngineSWRLBodyAtomArgumentWithVariableNamesConverter<String> {
    private final @NonNull DroolsSWRLVariable2NameConverter droolsSWRLVariable2NameConverter;
    private final @NonNull DroolsOWLLiteral2DRLConverter droolsOWLLiteral2DRLConverter;
    private final @NonNull DroolsOWLIndividual2DRLConverter droolsOWLIndividual2DRLConverter;
    private final @NonNull DroolsOWLEntity2NameConverter droolsOWLEntity2NameConverter;

    public DroolsSWRLBodyAtomArgument2DRLConverter(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsSWRLVariable2NameConverter droolsSWRLVariable2NameConverter, @NonNull DroolsOWLLiteral2DRLConverter droolsOWLLiteral2DRLConverter, @NonNull DroolsOWLIndividual2DRLConverter droolsOWLIndividual2DRLConverter, @NonNull DroolsOWLEntity2NameConverter droolsOWLEntity2NameConverter) {
        super(bridge);
        this.droolsSWRLVariable2NameConverter = droolsSWRLVariable2NameConverter;
        this.droolsOWLLiteral2DRLConverter = droolsOWLLiteral2DRLConverter;
        this.droolsOWLIndividual2DRLConverter = droolsOWLIndividual2DRLConverter;
        this.droolsOWLEntity2NameConverter = droolsOWLEntity2NameConverter;
    }

    public @NonNull String convert(@NonNull SWRLVariable variableArgument) {
        return this.getDroolsSWRLVariable2NameConverter().swrlVariable2DRL(variableArgument);
    }

    public @NonNull String convert(@NonNull SWRLLiteralArgument argument) {
        return this.getDroolsOWLLiteral2DRLConverter().convert(argument.getLiteral());
    }

    public @NonNull String convert(@NonNull SWRLIndividualArgument individualArgument) {
        OWLIndividual individual = individualArgument.getIndividual();
        return this.getDroolsOWLIndividual2DRLConverter().convert(individual);
    }

    public @NonNull String convert(@NonNull SWRLVariableBuiltInArgument variableArgument) {
        return this.getDroolsSWRLVariable2NameConverter().swrlVariable2DRL((SWRLVariable)variableArgument);
    }

    public @NonNull String convert(@NonNull SWRLClassBuiltInArgument classArgument) {
        return this.addQuotes(this.getDroolsOWLEntity2NameConverter().convert(classArgument.getOWLClass()));
    }

    public @NonNull String convert(@NonNull SWRLNamedIndividualBuiltInArgument namedIndividualArgument) {
        return this.addQuotes(this.getDroolsOWLEntity2NameConverter().convert(namedIndividualArgument.getOWLNamedIndividual()));
    }

    public @NonNull String convert(@NonNull SWRLObjectPropertyBuiltInArgument propertyArgument) {
        return this.addQuotes(this.getDroolsOWLEntity2NameConverter().convert(propertyArgument.getOWLObjectProperty()));
    }

    public @NonNull String convert(@NonNull SWRLDataPropertyBuiltInArgument propertyArgument) {
        return this.addQuotes(this.getDroolsOWLEntity2NameConverter().convert(propertyArgument.getOWLDataProperty()));
    }

    public @NonNull String convert(@NonNull SWRLAnnotationPropertyBuiltInArgument propertyArgument) {
        return this.addQuotes(this.getDroolsOWLEntity2NameConverter().convert(propertyArgument.getOWLAnnotationProperty()));
    }

    public @NonNull String convert(@NonNull SWRLDatatypeBuiltInArgument datatypeArgument) {
        return this.addQuotes(this.getDroolsOWLEntity2NameConverter().convert(datatypeArgument.getOWLDatatype()));
    }

    public @NonNull String convert(@NonNull SWRLLiteralBuiltInArgument argument) {
        return this.getDroolsOWLLiteral2DRLConverter().convert(argument.getLiteral());
    }

    public @NonNull String convert(@NonNull SQWRLCollectionVariableBuiltInArgument argument) {
        throw new TargetSWRLRuleEngineInternalException("unexpected call to convert a SQWRLCollectionBuiltInArgument");
    }

    public @NonNull String convert(@NonNull SQWRLCollectionVariableBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        throw new TargetSWRLRuleEngineInternalException("unexpected call to convert a SQWRLCollectionBuiltInArgument");
    }

    public @NonNull String convert(@NonNull SWRLVariableBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        String variableName = this.getDroolsSWRLVariable2NameConverter().swrlVariable2VariableName((SWRLVariable)argument);
        if (previouslyEncounteredVariableNames.contains(variableName)) {
            return fieldName + "==" + this.getDroolsSWRLVariable2NameConverter().variableName2DRL(variableName);
        }
        previouslyEncounteredVariableNames.add(variableName);
        return this.getDroolsSWRLVariable2NameConverter().variableName2DRL(variableName) + ":" + fieldName;
    }

    public @NonNull String convert(@NonNull SWRLVariable argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        String variableName = this.getDroolsSWRLVariable2NameConverter().swrlVariable2VariableName(argument);
        if (previouslyEncounteredVariableNames.contains(variableName)) {
            return fieldName + "==" + this.getDroolsSWRLVariable2NameConverter().variableName2DRL(variableName);
        }
        previouslyEncounteredVariableNames.add(variableName);
        return this.getDroolsSWRLVariable2NameConverter().variableName2DRL(variableName) + ":" + fieldName;
    }

    public @NonNull String convert(@NonNull SWRLIndividualArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLLiteralArgument argument, @NonNull String fieldName, Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLClassBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLNamedIndividualBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLObjectPropertyBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLDataPropertyBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLAnnotationPropertyBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLLiteralBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    public @NonNull String convert(@NonNull SWRLDatatypeBuiltInArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        return fieldName + "==" + this.convert(argument);
    }

    private @NonNull String addQuotes(@NonNull String s) {
        return "\"" + s + "\"";
    }

    public @NonNull String convert(@NonNull SWRLArgument argument, @NonNull String fieldName, @NonNull Set<@NonNull String> previouslyEncounteredVariableNames) {
        if (argument instanceof SQWRLCollectionVariableBuiltInArgument) {
            return this.convert((SQWRLCollectionVariableBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLVariableBuiltInArgument) {
            return this.convert((SWRLVariableBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLClassBuiltInArgument) {
            return this.convert((SWRLClassBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLNamedIndividualBuiltInArgument) {
            return this.convert((SWRLNamedIndividualBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLIndividualArgument) {
            return this.convert((SWRLIndividualArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLLiteralBuiltInArgument) {
            return this.convert((SWRLLiteralBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLObjectPropertyBuiltInArgument) {
            return this.convert((SWRLObjectPropertyBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLDataPropertyBuiltInArgument) {
            return this.convert((SWRLDataPropertyBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLAnnotationPropertyBuiltInArgument) {
            return this.convert((SWRLAnnotationPropertyBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLDatatypeBuiltInArgument) {
            return this.convert((SWRLDatatypeBuiltInArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLVariable) {
            return this.convert((SWRLVariable)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        if (argument instanceof SWRLLiteralArgument) {
            return this.convert((SWRLLiteralArgument)argument, fieldName, (Set)previouslyEncounteredVariableNames);
        }
        throw new TargetSWRLRuleEngineInternalException("unknown SWRL argument type " + argument.getClass().getCanonicalName());
    }

    private @NonNull DroolsSWRLVariable2NameConverter getDroolsSWRLVariable2NameConverter() {
        return this.droolsSWRLVariable2NameConverter;
    }

    private @NonNull DroolsOWLLiteral2DRLConverter getDroolsOWLLiteral2DRLConverter() {
        return this.droolsOWLLiteral2DRLConverter;
    }

    private @NonNull DroolsOWLIndividual2DRLConverter getDroolsOWLIndividual2DRLConverter() {
        return this.droolsOWLIndividual2DRLConverter;
    }

    private @NonNull DroolsOWLEntity2NameConverter getDroolsOWLEntity2NameConverter() {
        return this.droolsOWLEntity2NameConverter;
    }
}

