/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineSWRLBuiltInArgumentConverter;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentVisitorEx;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.drools.converters.drl.DroolsDRLConverterBase;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.exceptions.TargetSWRLRuleEngineNotImplementedFeatureException;

public class DroolsSWRLBuiltInArgument2DRLConverter
extends DroolsDRLConverterBase
implements TargetRuleEngineSWRLBuiltInArgumentConverter<String>,
SWRLBuiltInArgumentVisitorEx<String> {
    private final @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;

    public DroolsSWRLBuiltInArgument2DRLConverter(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler) {
        super(bridge);
        this.droolsOWLClassExpressionHandler = droolsOWLClassExpressionHandler;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
    }

    public @NonNull String convert(@NonNull SWRLBuiltInArgument argument) {
        return (String)argument.accept((SWRLBuiltInArgumentVisitorEx)this);
    }

    public @NonNull String convert(@NonNull SWRLVariableBuiltInArgument argument) {
        if (argument.isUnbound()) {
            return "new UBA(" + this.addQuotes(this.getDroolsSWRLVariable2NameConverter().swrlVariable2VariableName((SWRLVariable)argument)) + ")";
        }
        return this.getDroolsSWRLVariable2NameConverter().swrlVariable2DRL((SWRLVariable)argument);
    }

    public @NonNull String convert(@NonNull SWRLClassBuiltInArgument argument) {
        String prefixedName = this.iri2PrefixedName(argument.getIRI());
        return "new C(" + this.addQuotes(prefixedName) + ")";
    }

    public @NonNull String convert(@NonNull SWRLClassExpressionBuiltInArgument argument) {
        OWLClassExpression classExpression = argument.getOWLClassExpression();
        String ceid = this.getDroolsOWLClassExpressionHandler().convert(classExpression).getceid();
        return "new CE(" + this.addQuotes(ceid) + ")";
    }

    public @NonNull String convert(@NonNull SWRLNamedIndividualBuiltInArgument argument) {
        String prefixedName = this.iri2PrefixedName(argument.getIRI());
        return "new I(" + this.addQuotes(prefixedName) + ")";
    }

    public @NonNull String convert(@NonNull SWRLObjectPropertyExpressionBuiltInArgument argument) {
        OWLObjectPropertyExpression propertyExpression = argument.getOWLObjectPropertyExpression();
        String peid = this.getDroolsOWLPropertyExpressionHandler().convert(propertyExpression).getid();
        return "new OPE(" + this.addQuotes(peid) + ")";
    }

    public @NonNull String convert(@NonNull SWRLObjectPropertyBuiltInArgument argument) {
        String prefixedName = this.iri2PrefixedName(argument.getIRI());
        return "new OP(" + this.addQuotes(prefixedName) + ")";
    }

    public @NonNull String convert(@NonNull SWRLDataPropertyBuiltInArgument argument) {
        String prefixedName = this.iri2PrefixedName(argument.getIRI());
        return "new DP(" + this.addQuotes(prefixedName) + ")";
    }

    public @NonNull String convert(@NonNull SWRLDataPropertyExpressionBuiltInArgument argument) {
        OWLDataPropertyExpression propertyExpression = argument.getOWLDataPropertyExpression();
        String peid = this.getDroolsOWLPropertyExpressionHandler().convert(propertyExpression).getid();
        return "new DPE(" + this.addQuotes(peid) + ")";
    }

    public @NonNull String convert(@NonNull SWRLAnnotationPropertyBuiltInArgument argument) {
        String prefixedName = this.iri2PrefixedName(argument.getIRI());
        return "new AP(" + this.addQuotes(prefixedName) + ")";
    }

    public @NonNull String convert(@NonNull SWRLDatatypeBuiltInArgument argument) {
        String prefixedName = this.iri2PrefixedName(argument.getIRI());
        return "new D(" + this.addQuotes(prefixedName) + ")";
    }

    public @NonNull String convert(@NonNull SWRLLiteralBuiltInArgument argument) {
        return this.getDroolsOWLLiteral2DRLConverter().convert(argument.getLiteral());
    }

    public @NonNull String convert(@NonNull SQWRLCollectionVariableBuiltInArgument argument) {
        throw new TargetSWRLRuleEngineNotImplementedFeatureException("SQWRL collection built-in arguments not yet implemented");
    }

    private @NonNull String addQuotes(@NonNull String s) {
        return "\"" + s + "\"";
    }

    public @NonNull String visit(@NonNull SWRLClassBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(SWRLClassExpressionBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLNamedIndividualBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLObjectPropertyBuiltInArgument argument) {
        return this.convert(argument);
    }

    public String visit(SWRLObjectPropertyExpressionBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLDataPropertyBuiltInArgument argument) {
        return this.convert(argument);
    }

    public String visit(SWRLDataPropertyExpressionBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLAnnotationPropertyBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLDatatypeBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLLiteralBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLVariableBuiltInArgument argument) {
        return this.convert(argument);
    }

    public @NonNull String visit(@NonNull SWRLMultiValueVariableBuiltInArgument argument) {
        return this.convert((SWRLVariableBuiltInArgument)argument);
    }

    public @NonNull String visit(SQWRLCollectionVariableBuiltInArgument argument) {
        return this.convert(argument);
    }

    private @NonNull DroolsOWLClassExpressionHandler getDroolsOWLClassExpressionHandler() {
        return this.droolsOWLClassExpressionHandler;
    }

    private @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }
}

