/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineSWRLHeadAtomConverter;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.drools.converters.drl.DroolsDRLConverterBase;
import org.swrlapi.drools.converters.drl.DroolsSWRLBuiltInArgument2DRLConverter;
import org.swrlapi.drools.converters.drl.DroolsSWRLHeadAtomArgument2DRLConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineNotImplementedFeatureException;

public class DroolsSWRLHeadAtom2DRLConverter
extends DroolsDRLConverterBase
implements TargetRuleEngineSWRLHeadAtomConverter<String> {
    private final @NonNull DroolsSWRLHeadAtomArgument2DRLConverter droolsSWRLHeadAtomArgument2DRLConverter;
    private final @NonNull DroolsSWRLBuiltInArgument2DRLConverter droolsSWRLBuiltInArgument2DRLConverter;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;
    private final @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler;
    private int inferredAxiomVariableIndex;
    private int builtInIndexInHead;

    public DroolsSWRLHeadAtom2DRLConverter(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler) {
        super(bridge);
        this.droolsSWRLHeadAtomArgument2DRLConverter = new DroolsSWRLHeadAtomArgument2DRLConverter(bridge);
        this.droolsSWRLBuiltInArgument2DRLConverter = new DroolsSWRLBuiltInArgument2DRLConverter(bridge, droolsOWLClassExpressionHandler, droolsOWLPropertyExpressionHandler);
        this.droolsOWLClassExpressionHandler = droolsOWLClassExpressionHandler;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
        this.inferredAxiomVariableIndex = 0;
        this.builtInIndexInHead = 0;
    }

    public void reset() {
        this.inferredAxiomVariableIndex = 0;
        this.builtInIndexInHead = 0;
    }

    public @NonNull String convert(@NonNull SWRLClassAtom atom) {
        String classID = this.getDroolsOWLClassExpressionHandler().convert(atom.getPredicate()).getceid();
        SWRLIArgument argument = (SWRLIArgument)atom.getArgument();
        String caaVariable = "caa" + this.inferredAxiomVariableIndex++;
        String representation = "CAA " + caaVariable + "=new " + "CAA" + "(" + this.addQuotes(classID) + ", ";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument) + ")";
        representation = representation + "); ";
        representation = representation + "inferrer.infer(" + caaVariable + "); ";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLObjectPropertyAtom atom) {
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(atom.getPredicate()).getid();
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLIArgument argument2 = (SWRLIArgument)atom.getSecondArgument();
        String opaaVariable = "opaa" + this.inferredAxiomVariableIndex++;
        String representation = "OPAA " + opaaVariable + "=new " + "OPAA" + "(";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument1) + ")";
        representation = representation + ", " + this.addQuotes(propertyID) + ", ";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument2) + ")";
        representation = representation + "); ";
        representation = representation + "inferrer.infer(" + opaaVariable + "); ";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLDataPropertyAtom atom) {
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(atom.getPredicate()).getid();
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLDArgument argument2 = (SWRLDArgument)atom.getSecondArgument();
        String dpaaVariable = "dpaa" + this.inferredAxiomVariableIndex++;
        String representation = "DPAA " + dpaaVariable + "=new " + "DPAA" + "(";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument1) + ")";
        representation = representation + ", " + this.addQuotes(propertyID) + ", ";
        representation = representation + "new L(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument2) + ")";
        representation = representation + "); ";
        representation = representation + "inferrer.infer(" + dpaaVariable + "); ";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLSameIndividualAtom atom) {
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLIArgument argument2 = (SWRLIArgument)atom.getSecondArgument();
        String siaVariable = "sia" + this.inferredAxiomVariableIndex++;
        String representation = "SIA " + siaVariable + "=new " + "SIA" + "(";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument1) + ")";
        representation = representation + ", ";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument2) + ")";
        representation = representation + "); ";
        representation = representation + "inferrer.infer(" + siaVariable + "); ";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLDifferentIndividualsAtom atom) {
        SWRLIArgument argument1 = (SWRLIArgument)atom.getFirstArgument();
        SWRLIArgument argument2 = (SWRLIArgument)atom.getSecondArgument();
        String diaVariable = "dia" + this.inferredAxiomVariableIndex++;
        String representation = "DIA " + diaVariable + "=new " + "DIA" + "(";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument1) + ")";
        representation = representation + ", ";
        representation = representation + "new I(" + this.getSWRLHeadAtomArgumentConverter().convert((SWRLArgument)argument2) + ")";
        representation = representation + "); ";
        representation = representation + "inferrer.infer(" + diaVariable + "); ";
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLAPIBuiltInAtom builtInAtom) {
        String builtInName = builtInAtom.getBuiltInPrefixedName();
        String ruleName = builtInAtom.getRuleName();
        String representation = "invoker.invoke(\"" + ruleName + "\", \"" + builtInName + "\", " + this.builtInIndexInHead + ", true, ";
        boolean isFirst = true;
        if (builtInAtom.getNumberOfArguments() > 11) {
            throw new SWRLAPIException("A maximum of 11 arguments can be passed to built-ins");
        }
        for (SWRLBuiltInArgument argument : builtInAtom.getBuiltInArguments()) {
            if (!isFirst) {
                representation = representation + ", ";
            }
            representation = representation + this.getSWRLBuiltInArgumentConverter().convert(argument);
            isFirst = false;
        }
        representation = representation + "); ";
        ++this.builtInIndexInHead;
        return representation;
    }

    public @NonNull String convert(@NonNull SWRLDataRangeAtom atom) {
        throw new TargetSWRLRuleEngineNotImplementedFeatureException("data range atoms not implemented in rule head");
    }

    public @NonNull String convert(@NonNull SWRLAtom atom) {
        if (atom instanceof SWRLDataRangeAtom) {
            return this.convert((SWRLDataRangeAtom)atom);
        }
        if (atom instanceof SWRLClassAtom) {
            return this.convert((SWRLClassAtom)atom);
        }
        if (atom instanceof SWRLDataPropertyAtom) {
            return this.convert((SWRLDataPropertyAtom)atom);
        }
        if (atom instanceof SWRLObjectPropertyAtom) {
            return this.convert((SWRLObjectPropertyAtom)atom);
        }
        if (atom instanceof SWRLSameIndividualAtom) {
            return this.convert((SWRLSameIndividualAtom)atom);
        }
        if (atom instanceof SWRLDifferentIndividualsAtom) {
            return this.convert((SWRLDifferentIndividualsAtom)atom);
        }
        if (atom instanceof SWRLAPIBuiltInAtom) {
            return this.convert((SWRLAPIBuiltInAtom)atom);
        }
        throw new TargetSWRLRuleEngineInternalException("unknown SWRL atom type " + atom.getClass().getCanonicalName());
    }

    private @NonNull DroolsSWRLHeadAtomArgument2DRLConverter getSWRLHeadAtomArgumentConverter() {
        return this.droolsSWRLHeadAtomArgument2DRLConverter;
    }

    private @NonNull DroolsSWRLBuiltInArgument2DRLConverter getSWRLBuiltInArgumentConverter() {
        return this.droolsSWRLBuiltInArgument2DRLConverter;
    }

    private @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }

    private @NonNull DroolsOWLClassExpressionHandler getDroolsOWLClassExpressionHandler() {
        return this.droolsOWLClassExpressionHandler;
    }

    private @NonNull String addQuotes(@NonNull String s) {
        return "\"" + s + "\"";
    }
}

