/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineSWRLHeadAtomArgumentConverter;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.drools.converters.drl.DroolsDRLConverterBase;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineNotImplementedFeatureException;

public class DroolsSWRLHeadAtomArgument2DRLConverter
extends DroolsDRLConverterBase
implements TargetRuleEngineSWRLHeadAtomArgumentConverter<String> {
    public DroolsSWRLHeadAtomArgument2DRLConverter(@NonNull SWRLRuleEngineBridge bridge) {
        super(bridge);
    }

    public @NonNull String convert(@NonNull SWRLVariable variableArgument) {
        return this.getDroolsSWRLVariable2NameConverter().swrlVariable2DRL(variableArgument);
    }

    public @NonNull String convert(@NonNull SWRLIndividualArgument individualArgument) {
        OWLIndividual individual = individualArgument.getIndividual();
        if (individual.isNamed()) {
            IRI iri = individual.asOWLNamedIndividual().getIRI();
            String prefixedName = this.iri2PrefixedName(iri);
            return this.addQuotes(prefixedName);
        }
        if (individual.isAnonymous()) {
            String id = individual.asOWLAnonymousIndividual().toStringID();
            return this.addQuotes(id);
        }
        throw new TargetSWRLRuleEngineInternalException("unknown OWL individual type " + individual.getClass().getCanonicalName() + " passed as a " + SWRLIndividualArgument.class.getName());
    }

    public @NonNull String convert(@NonNull SWRLLiteralArgument argument) {
        return this.getDroolsOWLLiteral2DRLConverter().convert(argument.getLiteral());
    }

    public @NonNull String convert(@NonNull SWRLVariableBuiltInArgument variableArgument) {
        return this.getDroolsSWRLVariable2NameConverter().swrlVariable2DRL((SWRLVariable)variableArgument);
    }

    public @NonNull String convert(@NonNull SWRLClassBuiltInArgument classArgument) {
        String prefixedName = this.iri2PrefixedName(classArgument.getIRI());
        return this.addQuotes(prefixedName);
    }

    public @NonNull String convert(@NonNull SWRLNamedIndividualBuiltInArgument individualArgument) {
        String prefixedName = this.iri2PrefixedName(individualArgument.getIRI());
        return this.addQuotes(prefixedName);
    }

    public @NonNull String convert(@NonNull SWRLObjectPropertyBuiltInArgument propertyArgument) {
        String prefixedName = this.iri2PrefixedName(propertyArgument.getIRI());
        return this.addQuotes(prefixedName);
    }

    public @NonNull String convert(@NonNull SWRLDataPropertyBuiltInArgument propertyArgument) {
        String prefixedName = this.iri2PrefixedName(propertyArgument.getIRI());
        return this.addQuotes(prefixedName);
    }

    public @NonNull String convert(@NonNull SWRLAnnotationPropertyBuiltInArgument propertyArgument) {
        String prefixedName = this.iri2PrefixedName(propertyArgument.getIRI());
        return this.addQuotes(prefixedName);
    }

    public @NonNull String convert(@NonNull SWRLDatatypeBuiltInArgument datatypeArgument) {
        return this.iri2PrefixedName(datatypeArgument.getIRI());
    }

    public @NonNull String convert(@NonNull SWRLLiteralBuiltInArgument argument) {
        return this.getDroolsOWLLiteral2DRLConverter().convert(argument.getLiteral());
    }

    public @NonNull String convert(@NonNull SQWRLCollectionVariableBuiltInArgument argument) {
        throw new TargetSWRLRuleEngineNotImplementedFeatureException("SQWRL collections can not be referenced in a rule head");
    }

    public @NonNull String convert(@NonNull SWRLArgument argument) {
        if (argument instanceof SQWRLCollectionVariableBuiltInArgument) {
            return this.convert((SQWRLCollectionVariableBuiltInArgument)argument);
        }
        if (argument instanceof SWRLVariableBuiltInArgument) {
            return this.convert((SWRLVariableBuiltInArgument)argument);
        }
        if (argument instanceof SWRLLiteralBuiltInArgument) {
            return this.convert((SWRLLiteralBuiltInArgument)argument);
        }
        if (argument instanceof SWRLClassBuiltInArgument) {
            return this.convert((SWRLClassBuiltInArgument)argument);
        }
        if (argument instanceof SWRLNamedIndividualBuiltInArgument) {
            return this.convert((SWRLNamedIndividualBuiltInArgument)argument);
        }
        if (argument instanceof SWRLObjectPropertyBuiltInArgument) {
            return this.convert((SWRLObjectPropertyBuiltInArgument)argument);
        }
        if (argument instanceof SWRLDataPropertyBuiltInArgument) {
            return this.convert((SWRLDataPropertyBuiltInArgument)argument);
        }
        if (argument instanceof SWRLAnnotationPropertyBuiltInArgument) {
            return this.convert((SWRLAnnotationPropertyBuiltInArgument)argument);
        }
        if (argument instanceof SWRLDatatypeBuiltInArgument) {
            return this.convert((SWRLDatatypeBuiltInArgument)argument);
        }
        if (argument instanceof SWRLVariable) {
            return this.convert((SWRLVariable)argument);
        }
        if (argument instanceof SWRLLiteralArgument) {
            return this.convert((SWRLLiteralArgument)argument);
        }
        if (argument instanceof SWRLIndividualArgument) {
            return this.convert((SWRLIndividualArgument)argument);
        }
        throw new TargetSWRLRuleEngineInternalException("unknown SWRL atom argument type " + argument.getClass().getCanonicalName());
    }

    private @NonNull String addQuotes(@NonNull String s) {
        return "\"" + s + "\"";
    }
}

