/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.drl;

import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.drools.converters.drl.DroolsDRLConverterBase;
import org.swrlapi.drools.converters.drl.DroolsSWRLBodyAtom2DRLConverter;
import org.swrlapi.drools.converters.drl.DroolsSWRLHeadAtom2DRLConverter;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.core.DroolsSWRLRuleEngine;
import org.swrlapi.exceptions.SWRLBuiltInException;

public class DroolsSWRLRule2DRLConverter
extends DroolsDRLConverterBase {
    private final @NonNull DroolsSWRLBodyAtom2DRLConverter bodyAtom2DRLConverter;
    private final @NonNull DroolsSWRLHeadAtom2DRLConverter headAtom2DRLConverter;
    private final @NonNull DroolsSWRLRuleEngine droolsSWRLRuleEngine;

    public DroolsSWRLRule2DRLConverter(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsSWRLRuleEngine droolsSWRLRuleEngine, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler) {
        super(bridge);
        this.bodyAtom2DRLConverter = new DroolsSWRLBodyAtom2DRLConverter(bridge, droolsOWLClassExpressionHandler, droolsOWLPropertyExpressionHandler, droolsOWLDataRangeHandler);
        this.headAtom2DRLConverter = new DroolsSWRLHeadAtom2DRLConverter(bridge, droolsOWLClassExpressionHandler, droolsOWLPropertyExpressionHandler);
        this.droolsSWRLRuleEngine = droolsSWRLRuleEngine;
    }

    public void convert(@NonNull SWRLAPIRule rule) throws SWRLBuiltInException {
        String ruleName = rule.getRuleName();
        String drlRule = this.getRulePreamble(ruleName);
        HashSet<@NonNull String> previouslyEncounteredVariableNames = new HashSet<String>();
        this.getDroolsSWRLBodyAtom2DRLConverter().reset();
        this.getDroolsSWRLHeadAtom2DRLConverter().reset();
        for (SWRLAtom atom : rule.getBodyAtoms()) {
            drlRule = drlRule + "\n   " + this.getDroolsSWRLBodyAtom2DRLConverter().convert(atom, previouslyEncounteredVariableNames) + " ";
        }
        drlRule = this.addRuleThenClause(drlRule);
        for (SWRLAtom atom : rule.getHeadAtoms()) {
            drlRule = drlRule + "\n   " + this.getDroolsSWRLHeadAtom2DRLConverter().convert(atom) + " ";
        }
        drlRule = this.addRuleEndClause(drlRule);
        this.getDroolsSWRLRuleEngine().defineDRLRule(drlRule);
    }

    private @NonNull String getRulePreamble(@NonNull String ruleName) {
        return "rule \"" + ruleName + "\" \nwhen ";
    }

    private @NonNull String addRuleEndClause(@NonNull String ruleText) {
        return ruleText + "\nend";
    }

    private @NonNull String addRuleThenClause(@NonNull String ruleText) {
        return ruleText + "\nthen ";
    }

    private @NonNull DroolsSWRLBodyAtom2DRLConverter getDroolsSWRLBodyAtom2DRLConverter() {
        return this.bodyAtom2DRLConverter;
    }

    private @NonNull DroolsSWRLHeadAtom2DRLConverter getDroolsSWRLHeadAtom2DRLConverter() {
        return this.headAtom2DRLConverter;
    }

    private @NonNull DroolsSWRLRuleEngine getDroolsSWRLRuleEngine() {
        return this.droolsSWRLRuleEngine;
    }
}

