/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.id;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineConverterBase;
import org.swrlapi.bridge.converters.TargetRuleEngineOWLDataRangeConverter;
import org.swrlapi.drools.owl.dataranges.DCO;
import org.swrlapi.drools.owl.dataranges.DIO;
import org.swrlapi.drools.owl.dataranges.DOO;
import org.swrlapi.drools.owl.dataranges.DR;
import org.swrlapi.drools.owl.dataranges.DRR;
import org.swrlapi.drools.owl.dataranges.DUO;
import org.swrlapi.drools.owl.literals.L;

public class DroolsOWLDataRangeHandler
extends TargetRuleEngineConverterBase
implements TargetRuleEngineOWLDataRangeConverter<String>,
OWLDataRangeVisitorEx<String> {
    private final @NonNull Map<@NonNull OWLDataRange, @NonNull String> dataRange2ID = new HashMap<OWLDataRange, String>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataRange> id2DataRange = new HashMap<String, OWLDataRange>();
    private final @NonNull Set<@NonNull String> convertedDataRangeIDs = new HashSet<String>();
    private final @NonNull Set<@NonNull DR> dataRanges = new HashSet<DR>();
    private int dataRangeIndex = 0;

    public DroolsOWLDataRangeHandler(@NonNull SWRLRuleEngineBridge bridge) {
        super(bridge);
    }

    public void reset() {
        this.dataRangeIndex = 0;
        this.dataRange2ID.clear();
        this.id2DataRange.clear();
        this.convertedDataRangeIDs.clear();
        this.dataRanges.clear();
    }

    public @NonNull OWLDataRange resolveOWLDataRange(String drid) {
        if (this.id2DataRange.containsKey(drid)) {
            return this.id2DataRange.get(drid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data range from a Drools data range with id " + drid);
    }

    public @NonNull String convert(@NonNull OWLDataRange dataRange) {
        return (String)dataRange.accept((OWLDataRangeVisitorEx)this);
    }

    public @NonNull String convert(@NonNull OWLDatatype datatype) {
        String dataRangeID = this.iri2PrefixedName(datatype.getIRI());
        if (!this.convertedDataRangeIDs.contains(dataRangeID)) {
            this.convertedDataRangeIDs.add(dataRangeID);
            this.id2DataRange.put(dataRangeID, (OWLDataRange)datatype);
            this.dataRange2ID.put((OWLDataRange)datatype, dataRangeID);
        }
        return dataRangeID;
    }

    public String convert(OWLDataOneOf dataRange) {
        String dataRangeID = this.getOWLDataRangeID((OWLDataRange)dataRange);
        if (!this.convertedDataRangeIDs.contains(dataRangeID)) {
            HashSet<@NonNull L> literals = new HashSet<L>();
            DOO doo = new DOO(dataRangeID, literals);
            this.addOWLDataRange(doo);
        }
        return dataRangeID;
    }

    public String convert(@NonNull OWLDataComplementOf dataRange) {
        String dataRangeID = this.getOWLDataRangeID((OWLDataRange)dataRange);
        if (!this.convertedDataRangeIDs.contains(dataRangeID)) {
            String complementDataRangeID = this.getOWLDataRangeID(dataRange.getDataRange());
            DCO dco = new DCO(dataRangeID, complementDataRangeID);
            this.addOWLDataRange(dco);
        }
        return dataRangeID;
    }

    public String convert(@NonNull OWLDataIntersectionOf dataRange) {
        String dataRangeID = this.getOWLDataRangeID((OWLDataRange)dataRange);
        if (!this.convertedDataRangeIDs.contains(dataRangeID)) {
            Set<@NonNull String> dataRangeIDs = this.getOWLDataRangeIDs(dataRange.getOperands());
            DIO dio = new DIO(dataRangeID, dataRangeIDs);
            this.addOWLDataRange(dio);
        }
        return dataRangeID;
    }

    public String convert(@NonNull OWLDataUnionOf dataRange) {
        String dataRangeID = this.getOWLDataRangeID((OWLDataRange)dataRange);
        if (!this.convertedDataRangeIDs.contains(dataRangeID)) {
            Set<@NonNull String> dataRangeIDs = this.getOWLDataRangeIDs(dataRange.getOperands());
            DUO duo = new DUO(dataRangeID, dataRangeIDs);
            this.addOWLDataRange(duo);
        }
        return dataRangeID;
    }

    public String convert(OWLDatatypeRestriction dataRange) {
        String dataRangeID = this.getOWLDataRangeID((OWLDataRange)dataRange);
        if (!this.convertedDataRangeIDs.contains(dataRangeID)) {
            DRR drr = new DRR(dataRangeID);
            this.addOWLDataRange(drr);
        }
        return dataRangeID;
    }

    public @NonNull String visit(@NonNull OWLDatatype owlDatatype) {
        return this.convert(owlDatatype);
    }

    public @NonNull String visit(@NonNull OWLDataOneOf owlDataOneOf) {
        return this.convert(owlDataOneOf);
    }

    public @NonNull String visit(@NonNull OWLDataComplementOf owlDataComplementOf) {
        return this.convert(owlDataComplementOf);
    }

    public @NonNull String visit(@NonNull OWLDataIntersectionOf owlDataIntersectionOf) {
        return this.convert(owlDataIntersectionOf);
    }

    public @NonNull String visit(@NonNull OWLDataUnionOf owlDataUnionOf) {
        return this.convert(owlDataUnionOf);
    }

    public @NonNull String visit(OWLDatatypeRestriction owlDatatypeRestriction) {
        return this.convert(owlDatatypeRestriction);
    }

    private String getOWLDataRangeID(OWLDataRange dataRange) {
        if (this.dataRange2ID.containsKey(dataRange)) {
            return this.dataRange2ID.get(dataRange);
        }
        String dataRangeID = "DRID" + this.dataRangeIndex++;
        this.dataRange2ID.put(dataRange, dataRangeID);
        this.convertedDataRangeIDs.add(dataRangeID);
        this.id2DataRange.put(dataRangeID, dataRange);
        this.dataRange2ID.put(dataRange, dataRangeID);
        return dataRangeID;
    }

    private @NonNull Set<@NonNull String> getOWLDataRangeIDs(@NonNull Set<@NonNull OWLDataRange> dataRanges) {
        HashSet<@NonNull String> dataRangeIDs = new HashSet<String>();
        for (OWLDataRange dataRange : dataRanges) {
            String dataRangeID = this.getOWLDataRangeID(dataRange);
            dataRangeIDs.add(dataRangeID);
        }
        return dataRangeIDs;
    }

    private void addOWLDataRange(DR dataRange) {
        this.dataRanges.add(dataRange);
    }
}

