/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.oo;

import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineOWLAxiomConverter;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.drools.converters.drl.DroolsSWRLRule2DRLConverter;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.oo.DroolsOOConverterBase;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.core.DroolsSWRLRuleEngine;
import org.swrlapi.drools.owl.axioms.A;
import org.swrlapi.drools.owl.axioms.AOPA;
import org.swrlapi.drools.owl.axioms.APDA;
import org.swrlapi.drools.owl.axioms.CAA;
import org.swrlapi.drools.owl.axioms.CDA;
import org.swrlapi.drools.owl.axioms.DCA;
import org.swrlapi.drools.owl.axioms.DDPA;
import org.swrlapi.drools.owl.axioms.DIA;
import org.swrlapi.drools.owl.axioms.DJDPA;
import org.swrlapi.drools.owl.axioms.DJOPA;
import org.swrlapi.drools.owl.axioms.DOPA;
import org.swrlapi.drools.owl.axioms.DPAA;
import org.swrlapi.drools.owl.axioms.DPDA;
import org.swrlapi.drools.owl.axioms.DPRA;
import org.swrlapi.drools.owl.axioms.ECA;
import org.swrlapi.drools.owl.axioms.EDPA;
import org.swrlapi.drools.owl.axioms.EOPA;
import org.swrlapi.drools.owl.axioms.FDPA;
import org.swrlapi.drools.owl.axioms.FOPA;
import org.swrlapi.drools.owl.axioms.IDA;
import org.swrlapi.drools.owl.axioms.IFOPA;
import org.swrlapi.drools.owl.axioms.IOPA;
import org.swrlapi.drools.owl.axioms.IROPA;
import org.swrlapi.drools.owl.axioms.NDPAA;
import org.swrlapi.drools.owl.axioms.NOPAA;
import org.swrlapi.drools.owl.axioms.OPAA;
import org.swrlapi.drools.owl.axioms.OPDA;
import org.swrlapi.drools.owl.axioms.OPRA;
import org.swrlapi.drools.owl.axioms.SCA;
import org.swrlapi.drools.owl.axioms.SDPA;
import org.swrlapi.drools.owl.axioms.SIA;
import org.swrlapi.drools.owl.axioms.SOPA;
import org.swrlapi.drools.owl.axioms.SPA;
import org.swrlapi.drools.owl.axioms.TOPA;
import org.swrlapi.drools.owl.classes.CE;
import org.swrlapi.drools.owl.individuals.I;
import org.swrlapi.drools.owl.literals.L;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;
import org.swrlapi.visitors.SWRLAPIOWLAxiomVisitor;

public class DroolsOWLAxiom2AConverter
extends DroolsOOConverterBase
implements TargetRuleEngineOWLAxiomConverter,
SWRLAPIOWLAxiomVisitor {
    private final @NonNull DroolsSWRLRule2DRLConverter droolsSWRLRule2DRLConverter;
    private final @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;
    private final @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler;
    private final @NonNull Set<@NonNull A> assertedOWLAxioms = new HashSet<A>();

    public DroolsOWLAxiom2AConverter(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsSWRLRuleEngine droolsSWRLRuleEngine, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler) {
        super(bridge);
        this.droolsSWRLRule2DRLConverter = new DroolsSWRLRule2DRLConverter(bridge, droolsSWRLRuleEngine, droolsOWLClassExpressionHandler, droolsOWLPropertyExpressionHandler, droolsOWLDataRangeHandler);
        this.droolsOWLClassExpressionHandler = droolsOWLClassExpressionHandler;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
        this.droolsOWLDataRangeHandler = droolsOWLDataRangeHandler;
    }

    public void reset() {
        this.assertedOWLAxioms.clear();
    }

    public @NonNull Set<@NonNull A> getAssertedOWLAxioms() {
        return new HashSet<A>(this.assertedOWLAxioms);
    }

    public @NonNull Set<@NonNull CE> getOWLClassExpressions() {
        return this.droolsOWLClassExpressionHandler.getCEs();
    }

    public void convert(@NonNull SWRLAPIRule rule) throws SWRLBuiltInException {
        this.getDroolsSWRLRule2DRLConverter().convert(rule);
    }

    public void convert(@NonNull OWLDeclarationAxiom axiom) {
        OWLEntity entity = axiom.getEntity();
        if (entity.isOWLClass()) {
            OWLClass cls = axiom.getEntity().asOWLClass();
            String classID = this.getDroolsOWLClassExpressionHandler().convert(cls).getceid();
            this.recordOWLAxiom(new CDA(classID));
        } else if (entity.isOWLNamedIndividual()) {
            OWLNamedIndividual individual = entity.asOWLNamedIndividual();
            String individualPrefixedName = this.getDroolsOWLEntity2NameConverter().convert(individual);
            this.recordOWLAxiom(new IDA(individualPrefixedName));
            this.recordOWLAxiom(new CAA("owl:Thing", individualPrefixedName));
        } else if (entity.isOWLObjectProperty()) {
            OWLObjectProperty property = entity.asOWLObjectProperty();
            String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert((OWLObjectPropertyExpression)property).getid();
            this.recordOWLAxiom(new OPDA(propertyID));
        } else if (entity.isOWLDataProperty()) {
            OWLDataProperty property = entity.asOWLDataProperty();
            String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert((OWLDataPropertyExpression)property).getid();
            this.recordOWLAxiom(new DPDA(propertyID));
        } else if (entity.isOWLAnnotationProperty()) {
            OWLAnnotationProperty property = entity.asOWLAnnotationProperty();
            String propertyPrefixedName = this.getDroolsOWLEntity2NameConverter().convert(property);
            this.recordOWLAxiom(new APDA(propertyPrefixedName));
        } else {
            throw new TargetSWRLRuleEngineInternalException("unknown entity type " + entity.getClass().getCanonicalName() + " in OWL declaration axiom");
        }
    }

    public void convert(@NonNull OWLClassAssertionAxiom axiom) {
        OWLClassExpression cls = axiom.getClassExpression();
        OWLIndividual individual = axiom.getIndividual();
        String classID = this.getDroolsOWLClassExpressionHandler().convert(cls).getceid();
        I i = this.getDroolsOWLIndividual2IConverter().convert(individual);
        CAA caa = new CAA(classID, i);
        this.recordOWLAxiom(caa);
    }

    public void convert(@NonNull OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        OWLIndividual subjectIndividual = axiom.getSubject();
        OWLIndividual objectIndividual = (OWLIndividual)axiom.getObject();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(property).getid();
        I subjectI = this.getDroolsOWLIndividual2IConverter().convert(subjectIndividual);
        I objectI = this.getDroolsOWLIndividual2IConverter().convert(objectIndividual);
        OPAA opaa = new OPAA(subjectI, propertyID, objectI);
        this.recordOWLAxiom(opaa);
    }

    public void convert(@NonNull OWLDataPropertyAssertionAxiom axiom) {
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        OWLIndividual subjectIndividual = axiom.getSubject();
        OWLLiteral objectLiteral = (OWLLiteral)axiom.getObject();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(property).getid();
        I subjectI = this.getDroolsOWLIndividual2IConverter().convert(subjectIndividual);
        L literal = this.getDroolsOWLLiteral2LConverter().convert(objectLiteral);
        DPAA dpaa = new DPAA(subjectI, propertyID, literal);
        this.recordOWLAxiom(dpaa);
    }

    public void convert(@NonNull OWLSameIndividualAxiom axiom) {
        if (!axiom.getIndividuals().isEmpty()) {
            for (OWLIndividual individual1 : axiom.getIndividuals()) {
                HashSet<@NonNull E> sameIndividuals = new HashSet(axiom.getIndividuals());
                I i1 = this.getDroolsOWLIndividual2IConverter().convert(individual1);
                SIA sia = new SIA(i1, i1);
                sameIndividuals.remove(individual1);
                this.recordOWLAxiom(sia);
                for (OWLIndividual individual2 : sameIndividuals) {
                    I i2 = this.getDroolsOWLIndividual2IConverter().convert(individual2);
                    sia = new SIA(i1, i2);
                    this.recordOWLAxiom(sia);
                }
            }
        }
    }

    public void convert(@NonNull OWLDifferentIndividualsAxiom axiom) {
        if (!axiom.getIndividuals().isEmpty()) {
            for (OWLIndividual individual1 : axiom.getIndividuals()) {
                HashSet<@NonNull E> differentIndividuals = new HashSet(axiom.getIndividuals());
                I i1 = this.getDroolsOWLIndividual2IConverter().convert(individual1);
                differentIndividuals.remove(individual1);
                for (OWLIndividual individual2 : differentIndividuals) {
                    I i2 = this.getDroolsOWLIndividual2IConverter().convert(individual2);
                    DIA dia = new DIA(i1, i2);
                    this.recordOWLAxiom(dia);
                }
            }
        }
    }

    public void convert(@NonNull OWLSubDataPropertyOfAxiom axiom) {
        OWLDataPropertyExpression subProperty = (OWLDataPropertyExpression)axiom.getSubProperty();
        OWLDataPropertyExpression superProperty = (OWLDataPropertyExpression)axiom.getSuperProperty();
        SDPA a = new SDPA(this.getDroolsOWLPropertyExpressionHandler().convert(subProperty).getid(), this.getDroolsOWLPropertyExpressionHandler().convert(superProperty).getid());
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLSubObjectPropertyOfAxiom axiom) {
        OWLObjectPropertyExpression subProperty = (OWLObjectPropertyExpression)axiom.getSubProperty();
        OWLObjectPropertyExpression superProperty = (OWLObjectPropertyExpression)axiom.getSuperProperty();
        SOPA a = new SOPA(this.getDroolsOWLPropertyExpressionHandler().convert(subProperty).getid(), this.getDroolsOWLPropertyExpressionHandler().convert(superProperty).getid());
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLInverseObjectPropertiesAxiom axiom) {
        OWLObjectPropertyExpression property1 = axiom.getFirstProperty();
        OWLObjectPropertyExpression property2 = axiom.getSecondProperty();
        IOPA a = new IOPA(this.getDroolsOWLPropertyExpressionHandler().convert(property1).getid(), this.getDroolsOWLPropertyExpressionHandler().convert(property2).getid());
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass = axiom.getSubClass();
        OWLClassExpression superClass = axiom.getSuperClass();
        SCA a = new SCA(this.getDroolsOWLClassExpressionHandler().convert(subClass).getceid(), this.getDroolsOWLClassExpressionHandler().convert(superClass).getceid());
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLDisjointClassesAxiom axiom) {
        if (!axiom.getClassExpressions().isEmpty()) {
            for (OWLClassExpression class1 : axiom.getClassExpressions()) {
                HashSet<@NonNull E> disjointClasses = new HashSet(axiom.getClassExpressions());
                String class1ID = this.getDroolsOWLClassExpressionHandler().convert(class1).getceid();
                disjointClasses.remove(class1);
                for (OWLClassExpression class2 : disjointClasses) {
                    String class2ID = this.getDroolsOWLClassExpressionHandler().convert(class2).getceid();
                    DCA a = new DCA(class1ID, class2ID);
                    this.recordOWLAxiom(a);
                    a = new DCA(class2ID, class1ID);
                    this.recordOWLAxiom(a);
                }
            }
        }
    }

    public void convert(@NonNull OWLEquivalentClassesAxiom axiom) {
        if (!axiom.getClassExpressions().isEmpty()) {
            for (OWLClassExpression class1 : axiom.getClassExpressions()) {
                HashSet<@NonNull E> equivalentClasses = new HashSet(axiom.getClassExpressions());
                String class1ID = this.getDroolsOWLClassExpressionHandler().convert(class1).getceid();
                equivalentClasses.remove(class1);
                for (OWLClassExpression class2 : equivalentClasses) {
                    String class2ID = this.getDroolsOWLClassExpressionHandler().convert(class2).getceid();
                    ECA a = new ECA(class1ID, class2ID);
                    this.recordOWLAxiom(a);
                }
            }
        }
    }

    public void convert(@NonNull OWLEquivalentObjectPropertiesAxiom axiom) {
        if (!axiom.getProperties().isEmpty()) {
            for (OWLObjectPropertyExpression property1 : axiom.getProperties()) {
                HashSet<@NonNull E> equivalentProperties = new HashSet(axiom.getProperties());
                String property1ID = this.getDroolsOWLPropertyExpressionHandler().convert(property1).getid();
                equivalentProperties.remove(property1);
                for (OWLObjectPropertyExpression property2 : equivalentProperties) {
                    String property2ID = this.getDroolsOWLPropertyExpressionHandler().convert(property2).getid();
                    EOPA a = new EOPA(property1ID, property2ID);
                    this.recordOWLAxiom(a);
                }
            }
        }
    }

    public void convert(@NonNull OWLEquivalentDataPropertiesAxiom axiom) {
        if (!axiom.getProperties().isEmpty()) {
            for (OWLDataPropertyExpression property1 : axiom.getProperties()) {
                HashSet<@NonNull E> equivalentProperties = new HashSet(axiom.getProperties());
                String property1ID = this.getDroolsOWLPropertyExpressionHandler().convert(property1).getid();
                equivalentProperties.remove(property1);
                for (OWLDataPropertyExpression property2 : equivalentProperties) {
                    String property2ID = this.getDroolsOWLPropertyExpressionHandler().convert(property2).getid();
                    EDPA a = new EDPA(property1ID, property2ID);
                    this.recordOWLAxiom(a);
                }
            }
        }
    }

    public void convert(@NonNull OWLDisjointObjectPropertiesAxiom axiom) {
        if (!axiom.getProperties().isEmpty()) {
            for (OWLObjectPropertyExpression property1 : axiom.getProperties()) {
                HashSet<@NonNull E> disjointProperties = new HashSet(axiom.getProperties());
                String property1ID = this.getDroolsOWLPropertyExpressionHandler().convert(property1).getid();
                disjointProperties.remove(property1);
                for (OWLObjectPropertyExpression property2 : disjointProperties) {
                    String property2ID = this.getDroolsOWLPropertyExpressionHandler().convert(property2).getid();
                    DJOPA a = new DJOPA(property1ID, property2ID);
                    this.recordOWLAxiom(a);
                }
            }
        }
    }

    public void convert(@NonNull OWLDisjointDataPropertiesAxiom axiom) {
        if (!axiom.getProperties().isEmpty()) {
            for (OWLDataPropertyExpression property1 : axiom.getProperties()) {
                HashSet<@NonNull E> disjointProperties = new HashSet(axiom.getProperties());
                String property1ID = this.getDroolsOWLPropertyExpressionHandler().convert(property1).getid();
                disjointProperties.remove(property1);
                for (OWLDataPropertyExpression property2 : disjointProperties) {
                    String property2ID = this.getDroolsOWLPropertyExpressionHandler().convert(property2).getid();
                    DJDPA a = new DJDPA(property1ID, property2ID);
                    this.recordOWLAxiom(a);
                }
            }
        }
    }

    public void convert(@NonNull OWLObjectPropertyDomainAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        OWLClassExpression domain = axiom.getDomain();
        DOPA a = new DOPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid(), this.getDroolsOWLClassExpressionHandler().convert(domain).getceid());
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLDataPropertyDomainAxiom axiom) {
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        OWLClassExpression domain = axiom.getDomain();
        DDPA a = new DDPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid(), this.getDroolsOWLClassExpressionHandler().convert(domain).getceid());
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLObjectPropertyRangeAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        OWLClassExpression domain = (OWLClassExpression)axiom.getRange();
        OPRA a = new OPRA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid(), this.getDroolsOWLClassExpressionHandler().convert(domain).getceid());
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLDataPropertyRangeAxiom axiom) {
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        OWLDataRange range = (OWLDataRange)axiom.getRange();
        DPRA a = new DPRA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid(), this.getDroolsOWLDataRangeHandler().convert(range));
        this.recordOWLAxiom(a);
    }

    public void convert(@NonNull OWLFunctionalObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        FOPA fopa = new FOPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid());
        this.recordOWLAxiom(fopa);
    }

    public void convert(@NonNull OWLFunctionalDataPropertyAxiom axiom) {
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        FDPA fdpa = new FDPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid());
        this.recordOWLAxiom(fdpa);
    }

    public void convert(@NonNull OWLInverseFunctionalObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        IFOPA ifopa = new IFOPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid());
        this.recordOWLAxiom(ifopa);
    }

    public void convert(@NonNull OWLIrreflexiveObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        IROPA iropa = new IROPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid());
        this.recordOWLAxiom(iropa);
    }

    public void convert(@NonNull OWLTransitiveObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        TOPA topa = new TOPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid());
        this.recordOWLAxiom(topa);
    }

    public void convert(@NonNull OWLSymmetricObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        SPA spa = new SPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid());
        this.recordOWLAxiom(spa);
    }

    public void convert(@NonNull OWLAsymmetricObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        AOPA aopa = new AOPA(this.getDroolsOWLPropertyExpressionHandler().convert(property).getid());
        this.recordOWLAxiom(aopa);
    }

    public void convert(@NonNull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        OWLIndividual subjectIndividual = axiom.getSubject();
        OWLIndividual objectIndividual = (OWLIndividual)axiom.getObject();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(property).getid();
        I subjectI = this.getDroolsOWLIndividual2IConverter().convert(subjectIndividual);
        I objectI = this.getDroolsOWLIndividual2IConverter().convert(objectIndividual);
        NOPAA nopaa = new NOPAA(subjectI, propertyID, objectI);
        this.recordOWLAxiom(nopaa);
    }

    public void convert(@NonNull OWLNegativeDataPropertyAssertionAxiom axiom) {
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        OWLIndividual subjectIndividual = axiom.getSubject();
        OWLLiteral objectLiteral = (OWLLiteral)axiom.getObject();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(property).getid();
        I subjectI = this.getDroolsOWLIndividual2IConverter().convert(subjectIndividual);
        L literal = this.getDroolsOWLLiteral2LConverter().convert(objectLiteral);
        NDPAA ndpaa = new NDPAA(subjectI, propertyID, literal);
        this.recordOWLAxiom(ndpaa);
    }

    public void convert(OWLSubPropertyChainOfAxiom axiom) {
    }

    public void convert(OWLHasKeyAxiom axiom) {
    }

    public void convert(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    public void convert(OWLDisjointUnionAxiom axiom) {
    }

    public void convert(OWLDatatypeDefinitionAxiom axiom) {
    }

    public void convert(OWLAnnotationAssertionAxiom axiom) {
    }

    public void convert(OWLAnnotationPropertyRangeAxiom axiom) {
    }

    public void convert(OWLAnnotationPropertyDomainAxiom axiom) {
    }

    public void convert(OWLSubAnnotationPropertyOfAxiom axiom) {
    }

    public void convert(@NonNull OWLAxiom axiom) {
        axiom.accept((OWLAxiomVisitor)this);
    }

    public void visit(SWRLRule swrlRule) {
        if (swrlRule instanceof SWRLAPIRule) {
            SWRLAPIRule swrlapiRule = (SWRLAPIRule)swrlRule;
            if (swrlapiRule.isActive() && !swrlapiRule.isSQWRLQuery()) {
                try {
                    this.convert(swrlapiRule);
                }
                catch (SWRLBuiltInException e) {
                    throw new TargetSWRLRuleEngineInternalException("Error converting SWRL rule " + swrlRule + ": " + e.getMessage());
                }
            }
        } else {
            throw new TargetSWRLRuleEngineInternalException("Unexpected SWRL rule " + swrlRule + " - expecting SWRLAPIRule");
        }
    }

    public void visit(@NonNull SWRLAPIRule swrlapiRule) throws SWRLBuiltInException {
        this.convert(swrlapiRule);
    }

    public void visit(@NonNull OWLDeclarationAxiom axiom) {
        this.convert(axiom);
    }

    public void visit(@NonNull OWLSubClassOfAxiom owlSubClassOfAxiom) {
        this.convert(owlSubClassOfAxiom);
    }

    public void visit(@NonNull OWLNegativeObjectPropertyAssertionAxiom owlNegativeObjectPropertyAssertionAxiom) {
        this.convert(owlNegativeObjectPropertyAssertionAxiom);
    }

    public void visit(@NonNull OWLAsymmetricObjectPropertyAxiom owlAsymmetricObjectPropertyAxiom) {
        this.convert(owlAsymmetricObjectPropertyAxiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom owlReflexiveObjectPropertyAxiom) {
        this.convert(owlReflexiveObjectPropertyAxiom);
    }

    public void visit(@NonNull OWLDisjointClassesAxiom owlDisjointClassesAxiom) {
        this.convert(owlDisjointClassesAxiom);
    }

    public void visit(@NonNull OWLDataPropertyDomainAxiom owlDataPropertyDomainAxiom) {
        this.convert(owlDataPropertyDomainAxiom);
    }

    public void visit(@NonNull OWLObjectPropertyDomainAxiom owlObjectPropertyDomainAxiom) {
        this.convert(owlObjectPropertyDomainAxiom);
    }

    public void visit(@NonNull OWLEquivalentObjectPropertiesAxiom owlEquivalentObjectPropertiesAxiom) {
        this.convert(owlEquivalentObjectPropertiesAxiom);
    }

    public void visit(@NonNull OWLNegativeDataPropertyAssertionAxiom owlNegativeDataPropertyAssertionAxiom) {
        this.convert(owlNegativeDataPropertyAssertionAxiom);
    }

    public void visit(@NonNull OWLDifferentIndividualsAxiom owlDifferentIndividualsAxiom) {
        this.convert(owlDifferentIndividualsAxiom);
    }

    public void visit(@NonNull OWLDisjointDataPropertiesAxiom owlDisjointDataPropertiesAxiom) {
        this.convert(owlDisjointDataPropertiesAxiom);
    }

    public void visit(@NonNull OWLDisjointObjectPropertiesAxiom owlDisjointObjectPropertiesAxiom) {
        this.convert(owlDisjointObjectPropertiesAxiom);
    }

    public void visit(@NonNull OWLObjectPropertyRangeAxiom owlObjectPropertyRangeAxiom) {
        this.convert(owlObjectPropertyRangeAxiom);
    }

    public void visit(@NonNull OWLObjectPropertyAssertionAxiom owlObjectPropertyAssertionAxiom) {
        this.convert(owlObjectPropertyAssertionAxiom);
    }

    public void visit(@NonNull OWLFunctionalObjectPropertyAxiom owlFunctionalObjectPropertyAxiom) {
        this.convert(owlFunctionalObjectPropertyAxiom);
    }

    public void visit(@NonNull OWLSubObjectPropertyOfAxiom owlSubObjectPropertyOfAxiom) {
        this.convert(owlSubObjectPropertyOfAxiom);
    }

    public void visit(OWLDisjointUnionAxiom owlDisjointUnionAxiom) {
        this.convert(owlDisjointUnionAxiom);
    }

    public void visit(@NonNull OWLSymmetricObjectPropertyAxiom owlSymmetricObjectPropertyAxiom) {
        this.convert(owlSymmetricObjectPropertyAxiom);
    }

    public void visit(@NonNull OWLDataPropertyRangeAxiom owlDataPropertyRangeAxiom) {
        this.convert(owlDataPropertyRangeAxiom);
    }

    public void visit(@NonNull OWLFunctionalDataPropertyAxiom owlFunctionalDataPropertyAxiom) {
        this.convert(owlFunctionalDataPropertyAxiom);
    }

    public void visit(@NonNull OWLEquivalentDataPropertiesAxiom owlEquivalentDataPropertiesAxiom) {
        this.convert(owlEquivalentDataPropertiesAxiom);
    }

    public void visit(@NonNull OWLClassAssertionAxiom owlClassAssertionAxiom) {
        this.convert(owlClassAssertionAxiom);
    }

    public void visit(@NonNull OWLEquivalentClassesAxiom owlEquivalentClassesAxiom) {
        this.convert(owlEquivalentClassesAxiom);
    }

    public void visit(@NonNull OWLDataPropertyAssertionAxiom owlDataPropertyAssertionAxiom) {
        this.convert(owlDataPropertyAssertionAxiom);
    }

    public void visit(@NonNull OWLTransitiveObjectPropertyAxiom owlTransitiveObjectPropertyAxiom) {
        this.convert(owlTransitiveObjectPropertyAxiom);
    }

    public void visit(@NonNull OWLIrreflexiveObjectPropertyAxiom owlIrreflexiveObjectPropertyAxiom) {
        this.convert(owlIrreflexiveObjectPropertyAxiom);
    }

    public void visit(@NonNull OWLSubDataPropertyOfAxiom owlSubDataPropertyOfAxiom) {
        this.convert(owlSubDataPropertyOfAxiom);
    }

    public void visit(@NonNull OWLInverseFunctionalObjectPropertyAxiom owlInverseFunctionalObjectPropertyAxiom) {
        this.convert(owlInverseFunctionalObjectPropertyAxiom);
    }

    public void visit(@NonNull OWLSameIndividualAxiom owlSameIndividualAxiom) {
        this.convert(owlSameIndividualAxiom);
    }

    public void visit(OWLSubPropertyChainOfAxiom owlSubPropertyChainOfAxiom) {
        this.convert(owlSubPropertyChainOfAxiom);
    }

    public void visit(@NonNull OWLInverseObjectPropertiesAxiom owlInverseObjectPropertiesAxiom) {
        this.convert(owlInverseObjectPropertiesAxiom);
    }

    public void visit(OWLHasKeyAxiom owlHasKeyAxiom) {
        this.convert(owlHasKeyAxiom);
    }

    public void visit(OWLDatatypeDefinitionAxiom owlDatatypeDefinitionAxiom) {
        this.convert(owlDatatypeDefinitionAxiom);
    }

    public void visit(OWLAnnotationAssertionAxiom owlAnnotationAssertionAxiom) {
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
    }

    public void visit(OWLAnnotationPropertyDomainAxiom owlAnnotationPropertyDomainAxiom) {
    }

    public void visit(OWLAnnotationPropertyRangeAxiom owlAnnotationPropertyRangeAxiom) {
    }

    private void recordOWLAxiom(@NonNull A a) {
        if (!this.assertedOWLAxioms.contains(a)) {
            this.assertedOWLAxioms.add(a);
        }
    }

    private @NonNull DroolsOWLClassExpressionHandler getDroolsOWLClassExpressionHandler() {
        return this.droolsOWLClassExpressionHandler;
    }

    private @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }

    private @NonNull DroolsSWRLRule2DRLConverter getDroolsSWRLRule2DRLConverter() {
        return this.droolsSWRLRule2DRLConverter;
    }

    @NonNull DroolsOWLDataRangeHandler getDroolsOWLDataRangeHandler() {
        return this.droolsOWLDataRangeHandler;
    }
}

