/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.oo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineConverterBase;
import org.swrlapi.bridge.converters.TargetRuleEngineOWLClassExpressionConverter;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLIndividual2IConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLLiteral2LConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.owl.classes.C;
import org.swrlapi.drools.owl.classes.CE;
import org.swrlapi.drools.owl.classes.CEConverter;
import org.swrlapi.drools.owl.classes.CEResolver;
import org.swrlapi.drools.owl.classes.DAVFCE;
import org.swrlapi.drools.owl.classes.DECCE;
import org.swrlapi.drools.owl.classes.DHVCE;
import org.swrlapi.drools.owl.classes.DMaxCCE;
import org.swrlapi.drools.owl.classes.DMinCCE;
import org.swrlapi.drools.owl.classes.DSVFCE;
import org.swrlapi.drools.owl.classes.OAVFCE;
import org.swrlapi.drools.owl.classes.OCOCE;
import org.swrlapi.drools.owl.classes.OECCE;
import org.swrlapi.drools.owl.classes.OHVCE;
import org.swrlapi.drools.owl.classes.OIOCE;
import org.swrlapi.drools.owl.classes.OMaxCCE;
import org.swrlapi.drools.owl.classes.OMinCCE;
import org.swrlapi.drools.owl.classes.OOHSCE;
import org.swrlapi.drools.owl.classes.OOOCE;
import org.swrlapi.drools.owl.classes.OSVFCE;
import org.swrlapi.drools.owl.classes.OUOCE;

public class DroolsOWLClassExpressionHandler
extends TargetRuleEngineConverterBase
implements TargetRuleEngineOWLClassExpressionConverter<CE>,
OWLClassExpressionVisitorEx<CE>,
CEConverter,
CEResolver {
    private final @NonNull DroolsOWLIndividual2IConverter droolsOWLIndividual2IConverter;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;
    private final @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler;
    private final @NonNull DroolsOWLLiteral2LConverter droolsOWLLiteral2LConverter;
    private final @NonNull Map<@NonNull OWLClass, @NonNull C> ce2c = new HashMap<OWLClass, C>();
    private final @NonNull Map<@NonNull OWLObjectIntersectionOf, @NonNull OIOCE> ce2oioce = new HashMap<OWLObjectIntersectionOf, OIOCE>();
    private final @NonNull Map<@NonNull OWLObjectUnionOf, @NonNull OUOCE> ce2ouoce = new HashMap<OWLObjectUnionOf, OUOCE>();
    private final @NonNull Map<@NonNull OWLObjectComplementOf, @NonNull OCOCE> ce2ococe = new HashMap<OWLObjectComplementOf, OCOCE>();
    private final @NonNull Map<@NonNull OWLObjectSomeValuesFrom, @NonNull OSVFCE> ce2osvfce = new HashMap<OWLObjectSomeValuesFrom, OSVFCE>();
    private final @NonNull Map<@NonNull OWLObjectAllValuesFrom, @NonNull OAVFCE> ce2oavfce = new HashMap<OWLObjectAllValuesFrom, OAVFCE>();
    private final @NonNull Map<@NonNull OWLObjectHasValue, @NonNull OHVCE> ce2ohvce = new HashMap<OWLObjectHasValue, OHVCE>();
    private final @NonNull Map<@NonNull OWLObjectExactCardinality, @NonNull OECCE> ce2oecce = new HashMap<OWLObjectExactCardinality, OECCE>();
    private final @NonNull Map<@NonNull OWLObjectMinCardinality, @NonNull OMinCCE> ce2omincce = new HashMap<OWLObjectMinCardinality, OMinCCE>();
    private final @NonNull Map<@NonNull OWLObjectMaxCardinality, @NonNull OMaxCCE> ce2omaxcce = new HashMap<OWLObjectMaxCardinality, OMaxCCE>();
    private final @NonNull Map<@NonNull OWLObjectHasSelf, @NonNull OOHSCE> ce2oohsce = new HashMap<OWLObjectHasSelf, OOHSCE>();
    private final @NonNull Map<@NonNull OWLObjectOneOf, @NonNull OOOCE> ce2oooce = new HashMap<OWLObjectOneOf, OOOCE>();
    private final @NonNull Map<@NonNull OWLDataSomeValuesFrom, @NonNull DSVFCE> ce2dsvfce = new HashMap<OWLDataSomeValuesFrom, DSVFCE>();
    private final @NonNull Map<@NonNull OWLDataAllValuesFrom, @NonNull DAVFCE> ce2davfce = new HashMap<OWLDataAllValuesFrom, DAVFCE>();
    private final @NonNull Map<@NonNull OWLDataHasValue, @NonNull DHVCE> ce2dhvce = new HashMap<OWLDataHasValue, DHVCE>();
    private final @NonNull Map<@NonNull OWLDataExactCardinality, @NonNull DECCE> ce2decce = new HashMap<OWLDataExactCardinality, DECCE>();
    private final @NonNull Map<@NonNull OWLDataMinCardinality, @NonNull DMinCCE> ce2dmincce = new HashMap<OWLDataMinCardinality, DMinCCE>();
    private final @NonNull Map<@NonNull OWLDataMaxCardinality, @NonNull DMaxCCE> ce2dmaxcce = new HashMap<OWLDataMaxCardinality, DMaxCCE>();
    private final @NonNull Map<@NonNull String, @NonNull OWLClass> c2ce = new HashMap<String, OWLClass>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectIntersectionOf> oioce2ce = new HashMap<String, OWLObjectIntersectionOf>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectUnionOf> ouoce2ce = new HashMap<String, OWLObjectUnionOf>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectComplementOf> ococe2ce = new HashMap<String, OWLObjectComplementOf>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectSomeValuesFrom> osvfce2ce = new HashMap<String, OWLObjectSomeValuesFrom>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectAllValuesFrom> oavfce2ce = new HashMap<String, OWLObjectAllValuesFrom>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectHasValue> ohvce2ce = new HashMap<String, OWLObjectHasValue>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectExactCardinality> oecce2ce = new HashMap<String, OWLObjectExactCardinality>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectMinCardinality> omincce2ce = new HashMap<String, OWLObjectMinCardinality>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectMaxCardinality> omaxcce2ce = new HashMap<String, OWLObjectMaxCardinality>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectHasSelf> oohsce2ce = new HashMap<String, OWLObjectHasSelf>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectOneOf> oooce2ce = new HashMap<String, OWLObjectOneOf>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataSomeValuesFrom> dsvfce2ce = new HashMap<String, OWLDataSomeValuesFrom>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataAllValuesFrom> davfce2ce = new HashMap<String, OWLDataAllValuesFrom>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataHasValue> dhvce2ce = new HashMap<String, OWLDataHasValue>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataExactCardinality> decce2ce = new HashMap<String, OWLDataExactCardinality>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataMinCardinality> dmincce2ce = new HashMap<String, OWLDataMinCardinality>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataMaxCardinality> dmaxcce2ce = new HashMap<String, OWLDataMaxCardinality>();
    private final @NonNull Map<@NonNull String, @NonNull CE> ces = new HashMap<String, CE>();
    private final @NonNull Map<@NonNull String, @NonNull OWLClassExpression> classExpressions = new HashMap<String, OWLClassExpression>();
    private int classExpressionIndex = 0;

    public DroolsOWLClassExpressionHandler(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsOWLIndividual2IConverter droolsOWLIndividual2IConverter, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler, @NonNull DroolsOWLLiteral2LConverter droolsOWLLiteral2LConverter) {
        super(bridge);
        this.droolsOWLIndividual2IConverter = droolsOWLIndividual2IConverter;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
        this.droolsOWLDataRangeHandler = droolsOWLDataRangeHandler;
        this.droolsOWLLiteral2LConverter = droolsOWLLiteral2LConverter;
        this.convert(this.getBridge().getSWRLAPIOWLDataFactory().getOWLThing());
        this.convert(this.getBridge().getSWRLAPIOWLDataFactory().getOWLNothing());
    }

    public @NonNull CE convert(@NonNull OWLClassExpression classExpression) {
        return (CE)classExpression.accept((OWLClassExpressionVisitorEx)this);
    }

    public void reset() {
        this.classExpressionIndex = 0;
        this.ce2c.clear();
        this.ce2oioce.clear();
        this.ce2ouoce.clear();
        this.ce2ococe.clear();
        this.ce2osvfce.clear();
        this.ce2oavfce.clear();
        this.ce2ohvce.clear();
        this.ce2oecce.clear();
        this.ce2omincce.clear();
        this.ce2omaxcce.clear();
        this.ce2oohsce.clear();
        this.ce2oooce.clear();
        this.ce2dsvfce.clear();
        this.ce2davfce.clear();
        this.ce2dhvce.clear();
        this.ce2decce.clear();
        this.ce2dmincce.clear();
        this.ce2dmaxcce.clear();
        this.c2ce.clear();
        this.oioce2ce.clear();
        this.ouoce2ce.clear();
        this.ococe2ce.clear();
        this.osvfce2ce.clear();
        this.oavfce2ce.clear();
        this.ohvce2ce.clear();
        this.oecce2ce.clear();
        this.omincce2ce.clear();
        this.omaxcce2ce.clear();
        this.oohsce2ce.clear();
        this.oooce2ce.clear();
        this.dsvfce2ce.clear();
        this.davfce2ce.clear();
        this.dhvce2ce.clear();
        this.decce2ce.clear();
        this.dmincce2ce.clear();
        this.dmaxcce2ce.clear();
        this.ces.clear();
        this.classExpressions.clear();
        this.convert(this.getBridge().getSWRLAPIOWLDataFactory().getOWLThing());
        this.convert(this.getBridge().getSWRLAPIOWLDataFactory().getOWLNothing());
    }

    public @NonNull C visit(@NonNull OWLClass cls) {
        if (this.ce2c.containsKey(cls)) {
            return this.ce2c.get(cls);
        }
        String classID = this.iri2PrefixedName(cls.getIRI());
        C c = new C(classID);
        this.ce2c.put(cls, c);
        this.c2ce.put(c.getceid(), cls);
        this.ces.put(classID, c);
        this.classExpressions.put(classID, (OWLClassExpression)cls);
        return c;
    }

    public @NonNull OIOCE visit(@NonNull OWLObjectIntersectionOf objectIntersectionOf) {
        if (this.ce2oioce.containsKey(objectIntersectionOf)) {
            return this.ce2oioce.get(objectIntersectionOf);
        }
        String classExpressionID = this.generateCEID();
        HashSet<String> classIDs = new HashSet<String>();
        for (OWLClassExpression ce : objectIntersectionOf.getOperands()) {
            String classID = this.convert(ce).getceid();
            classIDs.add(classID);
        }
        OIOCE oioce = new OIOCE(classExpressionID, (Set<String>)classIDs);
        this.ce2oioce.put(objectIntersectionOf, oioce);
        this.oioce2ce.put(oioce.getceid(), objectIntersectionOf);
        this.ces.put(classExpressionID, oioce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectIntersectionOf);
        return oioce;
    }

    public @NonNull OUOCE visit(@NonNull OWLObjectUnionOf objectUnionOf) {
        if (this.ce2ouoce.containsKey(objectUnionOf)) {
            return this.ce2ouoce.get(objectUnionOf);
        }
        String classExpressionID = this.generateCEID();
        HashSet<@NonNull String> classExpressionIDs = new HashSet<String>();
        for (OWLClassExpression ce : objectUnionOf.getOperands()) {
            String cid = this.convert(ce).getceid();
            classExpressionIDs.add(cid);
        }
        OUOCE ouoce = new OUOCE(classExpressionID, (Set<String>)classExpressionIDs);
        this.ce2ouoce.put(objectUnionOf, ouoce);
        this.ouoce2ce.put(ouoce.getceid(), objectUnionOf);
        this.ces.put(classExpressionID, ouoce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectUnionOf);
        return ouoce;
    }

    public @NonNull OCOCE visit(@NonNull OWLObjectComplementOf objectComplementOf) {
        if (this.ce2ococe.containsKey(objectComplementOf)) {
            return this.ce2ococe.get(objectComplementOf);
        }
        String classExpressionID = this.generateCEID();
        String complementClassID = this.convert(objectComplementOf.getOperand()).getceid();
        OCOCE ococe = new OCOCE(classExpressionID, complementClassID);
        this.ce2ococe.put(objectComplementOf, ococe);
        this.ococe2ce.put(ococe.getceid(), objectComplementOf);
        this.ces.put(classExpressionID, ococe);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectComplementOf);
        return ococe;
    }

    public @NonNull OSVFCE visit(@NonNull OWLObjectSomeValuesFrom objectSomeValuesFrom) {
        if (this.ce2osvfce.containsKey(objectSomeValuesFrom)) {
            return this.ce2osvfce.get(objectSomeValuesFrom);
        }
        String classExpressionID = this.generateCEID();
        String someValuesFromClassID = this.convert((OWLClassExpression)objectSomeValuesFrom.getFiller()).getceid();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(objectSomeValuesFrom.getProperty()).getid();
        OSVFCE osvfce = new OSVFCE(classExpressionID, propertyID, someValuesFromClassID);
        this.ce2osvfce.put(objectSomeValuesFrom, osvfce);
        this.osvfce2ce.put(osvfce.getceid(), objectSomeValuesFrom);
        this.ces.put(classExpressionID, osvfce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectSomeValuesFrom);
        return osvfce;
    }

    public @NonNull OAVFCE visit(@NonNull OWLObjectAllValuesFrom objectAllValuesFrom) {
        if (this.ce2oavfce.containsKey(objectAllValuesFrom)) {
            return this.ce2oavfce.get(objectAllValuesFrom);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(objectAllValuesFrom.getProperty()).getid();
        String allValuesFromClassID = this.convert((OWLClassExpression)objectAllValuesFrom.getFiller()).getceid();
        OAVFCE oavfce = new OAVFCE(classExpressionID, propertyID, allValuesFromClassID);
        this.ce2oavfce.put(objectAllValuesFrom, oavfce);
        this.oavfce2ce.put(oavfce.getceid(), objectAllValuesFrom);
        this.ces.put(classExpressionID, oavfce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectAllValuesFrom);
        return oavfce;
    }

    public @NonNull OHVCE visit(@NonNull OWLObjectHasValue objectHasValue) {
        if (this.ce2ohvce.containsKey(objectHasValue)) {
            return this.ce2ohvce.get(objectHasValue);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(objectHasValue.getProperty()).getid();
        String fillerIndividualID = this.getDroolsOWLIndividual2IConverter().convert((OWLIndividual)objectHasValue.getFiller()).getid();
        OHVCE ohvce = new OHVCE(classExpressionID, propertyID, fillerIndividualID);
        this.ce2ohvce.put(objectHasValue, ohvce);
        this.ohvce2ce.put(ohvce.getceid(), objectHasValue);
        this.ces.put(classExpressionID, ohvce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectHasValue);
        return ohvce;
    }

    public @NonNull OECCE visit(@NonNull OWLObjectExactCardinality objectExactCardinality) {
        if (this.ce2oecce.containsKey(objectExactCardinality)) {
            return this.ce2oecce.get(objectExactCardinality);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(objectExactCardinality.getProperty()).getid();
        int cardinality = objectExactCardinality.getCardinality();
        OECCE oecce = new OECCE(classExpressionID, propertyID, (Integer)cardinality);
        this.ce2oecce.put(objectExactCardinality, oecce);
        this.oecce2ce.put(oecce.getceid(), objectExactCardinality);
        this.ces.put(classExpressionID, oecce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectExactCardinality);
        return oecce;
    }

    public @NonNull OMinCCE visit(@NonNull OWLObjectMinCardinality objectMinCardinality) {
        if (this.ce2omincce.containsKey(objectMinCardinality)) {
            return this.ce2omincce.get(objectMinCardinality);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(objectMinCardinality.getProperty()).getid();
        int cardinality = objectMinCardinality.getCardinality();
        OMinCCE omincce = new OMinCCE(classExpressionID, propertyID, (Integer)cardinality);
        this.ce2omincce.put(objectMinCardinality, omincce);
        this.omincce2ce.put(omincce.getceid(), objectMinCardinality);
        this.ces.put(classExpressionID, omincce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectMinCardinality);
        return omincce;
    }

    public @NonNull OMaxCCE visit(@NonNull OWLObjectMaxCardinality objectMaxCardinality) {
        if (this.ce2omaxcce.containsKey(objectMaxCardinality)) {
            return this.ce2omaxcce.get(objectMaxCardinality);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(objectMaxCardinality.getProperty()).getid();
        int cardinality = objectMaxCardinality.getCardinality();
        OMaxCCE omaxcce = new OMaxCCE(classExpressionID, propertyID, cardinality);
        this.ce2omaxcce.put(objectMaxCardinality, omaxcce);
        this.omaxcce2ce.put(omaxcce.getceid(), objectMaxCardinality);
        this.ces.put(classExpressionID, omaxcce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectMaxCardinality);
        return omaxcce;
    }

    public @NonNull OOHSCE visit(@NonNull OWLObjectHasSelf objectHasSelf) {
        if (this.ce2oohsce.containsKey(objectHasSelf)) {
            return this.ce2oohsce.get(objectHasSelf);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(objectHasSelf.getProperty()).getid();
        OOHSCE oohsce = new OOHSCE(classExpressionID, propertyID);
        this.ce2oohsce.put(objectHasSelf, oohsce);
        this.oohsce2ce.put(oohsce.getceid(), objectHasSelf);
        this.ces.put(classExpressionID, oohsce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectHasSelf);
        return oohsce;
    }

    public @NonNull OOOCE visit(@NonNull OWLObjectOneOf objectOneOf) {
        if (this.ce2oooce.containsKey(objectOneOf)) {
            return this.ce2oooce.get(objectOneOf);
        }
        String classExpressionID = this.generateCEID();
        HashSet<@NonNull String> individualIDs = new HashSet<String>();
        for (OWLIndividual individual : objectOneOf.getIndividuals()) {
            String individualID = this.getDroolsOWLIndividual2IConverter().convert(individual).getid();
            individualIDs.add(individualID);
        }
        OOOCE oooce = new OOOCE(classExpressionID, (Set<String>)individualIDs);
        this.ce2oooce.put(objectOneOf, oooce);
        this.oooce2ce.put(oooce.getceid(), objectOneOf);
        this.ces.put(classExpressionID, oooce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)objectOneOf);
        return oooce;
    }

    public @NonNull DSVFCE visit(@NonNull OWLDataSomeValuesFrom dataSomeValuesFrom) {
        if (this.ce2dsvfce.containsKey(dataSomeValuesFrom)) {
            return this.ce2dsvfce.get(dataSomeValuesFrom);
        }
        String classExpressionID = this.generateCEID();
        String someValuesFromDataRangeID = this.getDroolsOWLDataRangeHandler().convert((OWLDataRange)dataSomeValuesFrom.getFiller());
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(dataSomeValuesFrom.getProperty()).getid();
        DSVFCE dsvfce = new DSVFCE(classExpressionID, propertyID, someValuesFromDataRangeID);
        this.ce2dsvfce.put(dataSomeValuesFrom, dsvfce);
        this.dsvfce2ce.put(dsvfce.getceid(), dataSomeValuesFrom);
        this.ces.put(classExpressionID, dsvfce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)dataSomeValuesFrom);
        return dsvfce;
    }

    public @NonNull DAVFCE visit(@NonNull OWLDataAllValuesFrom dataAllValuesFrom) {
        if (this.ce2davfce.containsKey(dataAllValuesFrom)) {
            return this.ce2davfce.get(dataAllValuesFrom);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(dataAllValuesFrom.getProperty()).getid();
        String allValuesFromDataRangeID = this.getDroolsOWLDataRangeHandler().convert((OWLDataRange)dataAllValuesFrom.getFiller());
        DAVFCE davfce = new DAVFCE(classExpressionID, propertyID, allValuesFromDataRangeID);
        this.ce2davfce.put(dataAllValuesFrom, davfce);
        this.davfce2ce.put(davfce.getceid(), dataAllValuesFrom);
        this.ces.put(classExpressionID, davfce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)dataAllValuesFrom);
        return davfce;
    }

    public @NonNull DHVCE visit(@NonNull OWLDataHasValue dataHasValue) {
        if (this.ce2dhvce.containsKey(dataHasValue)) {
            return this.ce2dhvce.get(dataHasValue);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(dataHasValue.getProperty()).getid();
        OWLLiteral fillerLiteral = (OWLLiteral)dataHasValue.getFiller();
        DHVCE dhvce = new DHVCE(classExpressionID, propertyID, this.getDroolsOWLLiteral2LConverter().convert(fillerLiteral));
        this.ce2dhvce.put(dataHasValue, dhvce);
        this.dhvce2ce.put(dhvce.getceid(), dataHasValue);
        this.ces.put(classExpressionID, dhvce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)dataHasValue);
        return dhvce;
    }

    public @NonNull DMinCCE visit(@NonNull OWLDataMinCardinality dataMinCardinality) {
        if (this.ce2dmincce.containsKey(dataMinCardinality)) {
            return this.ce2dmincce.get(dataMinCardinality);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(dataMinCardinality.getProperty()).getid();
        int cardinality = dataMinCardinality.getCardinality();
        DMinCCE dmincce = new DMinCCE(classExpressionID, propertyID, (Integer)cardinality);
        this.ce2dmincce.put(dataMinCardinality, dmincce);
        this.dmincce2ce.put(dmincce.getceid(), dataMinCardinality);
        this.ces.put(classExpressionID, dmincce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)dataMinCardinality);
        return dmincce;
    }

    public @NonNull DECCE visit(@NonNull OWLDataExactCardinality dataExactCardinality) {
        if (this.ce2decce.containsKey(dataExactCardinality)) {
            return this.ce2decce.get(dataExactCardinality);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(dataExactCardinality.getProperty()).getid();
        int cardinality = dataExactCardinality.getCardinality();
        DECCE decce = new DECCE(classExpressionID, propertyID, cardinality);
        this.ce2decce.put(dataExactCardinality, decce);
        this.decce2ce.put(decce.getceid(), dataExactCardinality);
        this.ces.put(classExpressionID, decce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)dataExactCardinality);
        return decce;
    }

    public @NonNull DMaxCCE visit(@NonNull OWLDataMaxCardinality dataMaxCardinality) {
        if (this.ce2dmaxcce.containsKey(dataMaxCardinality)) {
            return this.ce2dmaxcce.get(dataMaxCardinality);
        }
        String classExpressionID = this.generateCEID();
        String propertyID = this.getDroolsOWLPropertyExpressionHandler().convert(dataMaxCardinality.getProperty()).getid();
        int cardinality = dataMaxCardinality.getCardinality();
        DMaxCCE dmaxcce = new DMaxCCE(classExpressionID, propertyID, cardinality);
        this.ce2dmaxcce.put(dataMaxCardinality, dmaxcce);
        this.dmaxcce2ce.put(dmaxcce.getceid(), dataMaxCardinality);
        this.ces.put(classExpressionID, dmaxcce);
        this.classExpressions.put(classExpressionID, (OWLClassExpression)dataMaxCardinality);
        return dmaxcce;
    }

    public @NonNull C convert(OWLClass cls) {
        return this.visit(cls);
    }

    public @NonNull OOOCE convert(OWLObjectOneOf objectOneOf) {
        return this.visit(objectOneOf);
    }

    public @NonNull OIOCE convert(OWLObjectIntersectionOf objectIntersectionOf) {
        return this.visit(objectIntersectionOf);
    }

    public @NonNull OUOCE convert(OWLObjectUnionOf objectUnionOf) {
        return this.visit(objectUnionOf);
    }

    public @NonNull OSVFCE convert(OWLObjectSomeValuesFrom objectSomeValuesFrom) {
        return this.visit(objectSomeValuesFrom);
    }

    public @NonNull OCOCE convert(OWLObjectComplementOf objectComplementOf) {
        return this.visit(objectComplementOf);
    }

    public @NonNull DSVFCE convert(OWLDataSomeValuesFrom dataSomeValuesFrom) {
        return this.visit(dataSomeValuesFrom);
    }

    public @NonNull DECCE convert(OWLDataExactCardinality dataExactCardinality) {
        return this.visit(dataExactCardinality);
    }

    public @NonNull OECCE convert(OWLObjectExactCardinality objectExactCardinality) {
        return this.visit(objectExactCardinality);
    }

    public @NonNull DMinCCE convert(OWLDataMinCardinality dataMinCardinality) {
        return this.visit(dataMinCardinality);
    }

    public @NonNull OMinCCE convert(OWLObjectMinCardinality objectMinCardinality) {
        return this.visit(objectMinCardinality);
    }

    public @NonNull DMaxCCE convert(OWLDataMaxCardinality dataMaxCardinality) {
        return this.visit(dataMaxCardinality);
    }

    public @NonNull OMaxCCE convert(OWLObjectMaxCardinality objectMaxCardinality) {
        return this.visit(objectMaxCardinality);
    }

    public @NonNull DHVCE convert(OWLDataHasValue dataHasValue) {
        return this.visit(dataHasValue);
    }

    public @NonNull OHVCE convert(OWLObjectHasValue objectHasValue) {
        return this.visit(objectHasValue);
    }

    public @NonNull OAVFCE convert(OWLObjectAllValuesFrom objectAllValuesFrom) {
        return this.visit(objectAllValuesFrom);
    }

    public @NonNull DAVFCE convert(OWLDataAllValuesFrom dataAllValuesFrom) {
        return this.visit(dataAllValuesFrom);
    }

    public @NonNull OOHSCE convert(OWLObjectHasSelf objectHasSelf) {
        return this.visit(objectHasSelf);
    }

    @Override
    public @NonNull OWLClass convert(@NonNull C c) {
        return this.resolveOWLClass(c.getceid());
    }

    @Override
    public @NonNull OWLDataAllValuesFrom convert(@NonNull DAVFCE ce) {
        return this.resolveOWLDataAllValuesFrom(ce.getceid());
    }

    @Override
    public @NonNull OWLDataExactCardinality convert(@NonNull DECCE ce) {
        return this.resolveOWLDataExactCardinality(ce.getceid());
    }

    @Override
    public @NonNull OWLDataHasValue convert(@NonNull DHVCE ce) {
        return this.resolveOWLDataHasValue(ce.getceid());
    }

    @Override
    public @NonNull OWLDataMaxCardinality convert(@NonNull DMaxCCE ce) {
        return this.resolveOWLDataMaxCardinality(ce.getceid());
    }

    @Override
    public @NonNull OWLDataMinCardinality convert(@NonNull DMinCCE ce) {
        return this.resolveOWLDataMinCardinality(ce.getceid());
    }

    @Override
    public @NonNull OWLDataSomeValuesFrom convert(@NonNull DSVFCE ce) {
        return this.resolveOWLDataSomeValuesFrom(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectAllValuesFrom convert(@NonNull OAVFCE ce) {
        return this.resolveOWLObjectAllValuesFrom(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectHasValue convert(@NonNull OHVCE ce) {
        return this.resolveOWLObjectHasValue(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectIntersectionOf convert(@NonNull OIOCE ce) {
        return this.resolveOWLObjectIntersectionOf(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectMaxCardinality convert(@NonNull OMaxCCE ce) {
        return this.resolveOWLObjectMaxCardinality(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectMinCardinality convert(@NonNull OMinCCE ce) {
        return this.resolveOWLObjectMinCardinality(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectExactCardinality convert(@NonNull OECCE ce) {
        return this.resolveOWLObjectExactCardinality(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectSomeValuesFrom convert(@NonNull OSVFCE ce) {
        return this.resolveOWLObjectSomeValuesFrom(ce.getceid());
    }

    @Override
    public @NonNull OWLObjectUnionOf convert(@NonNull OUOCE ce) {
        return this.resolveOWLObjectUnionOf(ce.getceid());
    }

    @Override
    public @NonNull OWLClassExpression resolveOWLClassExpression(@NonNull String ceid) {
        if (this.ces.containsKey(ceid)) {
            return this.classExpressions.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLClass resolveOWLClass(@NonNull String ceid) {
        if (this.c2ce.containsKey(ceid)) {
            return this.c2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL class from a Drools class with id " + ceid);
    }

    @Override
    public @NonNull OWLDataAllValuesFrom resolveOWLDataAllValuesFrom(@NonNull String ceid) {
        if (this.davfce2ce.containsKey(ceid)) {
            return this.davfce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data all values from class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLDataExactCardinality resolveOWLDataExactCardinality(@NonNull String ceid) {
        if (this.decce2ce.containsKey(ceid)) {
            return this.decce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data exact cardinality class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLDataHasValue resolveOWLDataHasValue(@NonNull String ceid) {
        if (this.dhvce2ce.containsKey(ceid)) {
            return this.dhvce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data has value class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLDataMaxCardinality resolveOWLDataMaxCardinality(@NonNull String ceid) {
        if (this.dmaxcce2ce.containsKey(ceid)) {
            return this.dmaxcce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data max cardinality class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLDataMinCardinality resolveOWLDataMinCardinality(@NonNull String ceid) {
        if (this.dmincce2ce.containsKey(ceid)) {
            return this.dmincce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data min cardinality class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLDataSomeValuesFrom resolveOWLDataSomeValuesFrom(@NonNull String ceid) {
        if (this.dsvfce2ce.containsKey(ceid)) {
            return this.dsvfce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data some values from class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectAllValuesFrom resolveOWLObjectAllValuesFrom(@NonNull String ceid) {
        if (this.oavfce2ce.containsKey(ceid)) {
            return this.oavfce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object all values from class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectExactCardinality resolveOWLObjectExactCardinality(@NonNull String ceid) {
        if (this.oecce2ce.containsKey(ceid)) {
            return this.oecce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object exact cardinality class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectHasValue resolveOWLObjectHasValue(@NonNull String ceid) {
        if (this.ohvce2ce.containsKey(ceid)) {
            return this.ohvce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object has value class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectIntersectionOf resolveOWLObjectIntersectionOf(@NonNull String ceid) {
        if (this.oioce2ce.containsKey(ceid)) {
            return this.oioce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object intersection of class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectMaxCardinality resolveOWLObjectMaxCardinality(@NonNull String ceid) {
        if (this.omaxcce2ce.containsKey(ceid)) {
            return this.omaxcce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object max cardinality class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectMinCardinality resolveOWLObjectMinCardinality(@NonNull String ceid) {
        if (this.omincce2ce.containsKey(ceid)) {
            return this.omincce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object min cardinality class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectSomeValuesFrom resolveOWLObjectSomeValuesFrom(@NonNull String ceid) {
        if (this.osvfce2ce.containsKey(ceid)) {
            return this.osvfce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object some values from class expression from a Drools class expression with id " + ceid);
    }

    @Override
    public @NonNull OWLObjectUnionOf resolveOWLObjectUnionOf(@NonNull String ceid) {
        if (this.ouoce2ce.containsKey(ceid)) {
            return this.ouoce2ce.get(ceid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object union of class expression from a Drools class expression with id " + ceid);
    }

    public @NonNull Set<@NonNull CE> getCEs() {
        return new HashSet<CE>(this.ces.values());
    }

    private @NonNull String generateCEID() {
        return "CEID" + this.classExpressionIndex++;
    }

    private @NonNull DroolsOWLIndividual2IConverter getDroolsOWLIndividual2IConverter() {
        return this.droolsOWLIndividual2IConverter;
    }

    private @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }

    private @NonNull DroolsOWLLiteral2LConverter getDroolsOWLLiteral2LConverter() {
        return this.droolsOWLLiteral2LConverter;
    }

    private @NonNull DroolsOWLDataRangeHandler getDroolsOWLDataRangeHandler() {
        return this.droolsOWLDataRangeHandler;
    }
}

