/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.oo;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineConverterBase;
import org.swrlapi.bridge.converters.TargetRuleEngineOWLEntityConverter;
import org.swrlapi.drools.owl.classes.C;
import org.swrlapi.drools.owl.core.OE;
import org.swrlapi.drools.owl.dataranges.D;
import org.swrlapi.drools.owl.individuals.I;
import org.swrlapi.drools.owl.properties.AP;
import org.swrlapi.drools.owl.properties.DP;
import org.swrlapi.drools.owl.properties.OP;

public class DroolsOWLEntity2OEConverter
extends TargetRuleEngineConverterBase
implements TargetRuleEngineOWLEntityConverter<OE> {
    public DroolsOWLEntity2OEConverter(@NonNull SWRLRuleEngineBridge bridge) {
        super(bridge);
    }

    public @NonNull C convert(@NonNull OWLClass cls) {
        String prefixedName = this.iri2PrefixedName(cls.getIRI());
        return new C(prefixedName);
    }

    public @NonNull I convert(@NonNull OWLNamedIndividual individual) {
        String prefixedName = this.iri2PrefixedName(individual.getIRI());
        return new I(prefixedName);
    }

    public @NonNull OP convert(@NonNull OWLObjectProperty property) {
        String prefixedName = this.iri2PrefixedName(property.getIRI());
        return new OP(prefixedName);
    }

    public @NonNull DP convert(@NonNull OWLDataProperty property) {
        String prefixedName = this.iri2PrefixedName(property.getIRI());
        return new DP(prefixedName);
    }

    public @NonNull AP convert(@NonNull OWLAnnotationProperty property) {
        String prefixedName = this.iri2PrefixedName(property.getIRI());
        return new AP(prefixedName);
    }

    public @NonNull D convert(@NonNull OWLDatatype datatype) {
        String prefixedName = this.iri2PrefixedName(datatype.getIRI());
        return new D(prefixedName);
    }
}

