/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.converters.oo;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineConverterBase;
import org.swrlapi.bridge.converters.TargetRuleEngineOWLPropertyExpressionConverter;
import org.swrlapi.drools.owl.properties.AP;
import org.swrlapi.drools.owl.properties.DPE;
import org.swrlapi.drools.owl.properties.OPE;
import org.swrlapi.drools.owl.properties.PE;
import org.swrlapi.drools.owl.properties.PEConverter;
import org.swrlapi.drools.owl.properties.PEResolver;

public class DroolsOWLPropertyExpressionHandler
extends TargetRuleEngineConverterBase
implements TargetRuleEngineOWLPropertyExpressionConverter<PE>,
OWLPropertyExpressionVisitorEx<PE>,
PEConverter,
PEResolver {
    private int propertyExpressionIndex = 0;
    private final @NonNull Map<@NonNull OWLObjectPropertyExpression, OPE> pe2ope = new HashMap<OWLObjectPropertyExpression, OPE>();
    private final @NonNull Map<@NonNull OWLDataPropertyExpression, DPE> pe2dpe = new HashMap<OWLDataPropertyExpression, DPE>();
    private final @NonNull Map<@NonNull OWLAnnotationProperty, AP> ap2ap = new HashMap<OWLAnnotationProperty, AP>();
    private final @NonNull Map<@NonNull String, @NonNull OWLObjectPropertyExpression> peid2objectPropertyExpression = new HashMap<String, OWLObjectPropertyExpression>();
    private final @NonNull Map<@NonNull String, @NonNull OWLDataPropertyExpression> peid2dataPropertyExpression = new HashMap<String, OWLDataPropertyExpression>();
    private final @NonNull Map<@NonNull String, @NonNull OWLAnnotationProperty> pid2annotationProperty = new HashMap<String, OWLAnnotationProperty>();
    private final @NonNull Map<@NonNull String, OPE> peid2OPE = new HashMap<String, OPE>();
    private final @NonNull Map<@NonNull String, DPE> peid2DPE = new HashMap<String, DPE>();
    private final @NonNull Map<@NonNull String, AP> pid2AP = new HashMap<String, AP>();

    public DroolsOWLPropertyExpressionHandler(@NonNull SWRLRuleEngineBridge bridge) {
        super(bridge);
    }

    public void reset() {
        this.propertyExpressionIndex = 0;
        this.pe2ope.clear();
        this.pe2dpe.clear();
        this.ap2ap.clear();
        this.peid2OPE.clear();
        this.peid2DPE.clear();
        this.pid2AP.clear();
        this.peid2objectPropertyExpression.clear();
        this.peid2dataPropertyExpression.clear();
        this.pid2annotationProperty.clear();
    }

    public OPE convert(@NonNull OWLObjectPropertyExpression propertyExpression) {
        if (this.pe2ope.containsKey(propertyExpression)) {
            return this.pe2ope.get(propertyExpression);
        }
        String peid = this.generatePEID();
        OPE ope = new OPE(peid);
        this.pe2ope.put(propertyExpression, ope);
        this.peid2objectPropertyExpression.put(peid, propertyExpression);
        this.peid2OPE.put(peid, ope);
        return ope;
    }

    public DPE convert(@NonNull OWLDataPropertyExpression propertyExpression) {
        if (this.pe2dpe.containsKey(propertyExpression)) {
            return this.pe2dpe.get(propertyExpression);
        }
        String peid = this.generatePEID();
        DPE dpe = new DPE(peid);
        this.pe2dpe.put(propertyExpression, dpe);
        this.peid2dataPropertyExpression.put(peid, propertyExpression);
        this.peid2DPE.put(peid, dpe);
        return dpe;
    }

    public AP convert(OWLAnnotationProperty annotationProperty) {
        if (this.pid2AP.containsKey(annotationProperty)) {
            return this.pid2AP.get(annotationProperty);
        }
        String pid = this.generatePEID();
        AP ap = new AP(pid);
        this.ap2ap.put(annotationProperty, ap);
        this.pid2annotationProperty.put(pid, annotationProperty);
        this.pid2AP.put(pid, ap);
        return ap;
    }

    @Nonnull
    public OPE visit(@Nonnull OWLObjectProperty objectProperty) {
        return this.convert((OWLObjectPropertyExpression)objectProperty);
    }

    @Nonnull
    public OPE visit(@Nonnull OWLObjectInverseOf objectInverseOf) {
        return this.convert((OWLObjectPropertyExpression)objectInverseOf);
    }

    @Nonnull
    public DPE visit(@Nonnull OWLDataProperty dataProperty) {
        return this.convert((OWLDataPropertyExpression)dataProperty);
    }

    @Nonnull
    public AP visit(@Nonnull OWLAnnotationProperty annotationProperty) {
        return this.convert(annotationProperty);
    }

    @Override
    public @NonNull OWLObjectPropertyExpression convert(@NonNull OPE pe) {
        return this.resolveOWLObjectPropertyExpression(pe.getid());
    }

    @Override
    public @NonNull OWLDataPropertyExpression convert(@NonNull DPE pe) {
        return this.resolveOWLDataPropertyExpression(pe.getid());
    }

    @Override
    public @NonNull OWLAnnotationProperty convert(@NonNull AP ap) {
        return this.resolveOWLAnnotationProperty(ap.getid());
    }

    @Override
    public @NonNull OWLObjectPropertyExpression resolveOWLObjectPropertyExpression(@NonNull String peid) {
        if (this.peid2objectPropertyExpression.containsKey(peid)) {
            return this.peid2objectPropertyExpression.get(peid);
        }
        throw new IllegalArgumentException("could not resolve an OWL object property expression from a Drools object property expression with id " + peid);
    }

    @Override
    public @NonNull OWLDataPropertyExpression resolveOWLDataPropertyExpression(@NonNull String peid) {
        if (this.peid2dataPropertyExpression.containsKey(peid)) {
            return this.peid2dataPropertyExpression.get(peid);
        }
        throw new IllegalArgumentException("could not resolve an OWL data property expression from a Drools data property expression with id " + peid);
    }

    @Override
    public @NonNull OWLAnnotationProperty resolveOWLAnnotationProperty(@NonNull String pid) {
        if (this.pid2annotationProperty.containsKey(pid)) {
            return this.pid2annotationProperty.get(pid);
        }
        throw new IllegalArgumentException("could not resolve an OWL annotation property from a Drools annotation property with id " + pid);
    }

    private @NonNull String generatePEID() {
        return "PEID" + this.propertyExpressionIndex++;
    }
}

