/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.core;

import java.io.Reader;
import java.io.StringReader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.io.ResourceFactory;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;

public class DroolsResourceHandler {
    private final @NonNull KnowledgeBuilder knowledgeBuilder;

    public DroolsResourceHandler(@NonNull KnowledgeBuilder knowledgeBuilder) {
        this.knowledgeBuilder = knowledgeBuilder;
    }

    public void defineJavaResources() {
        this.defineGlobalJavaObjects();
        this.importOWLAndSWRLJavaClasses();
    }

    public void defineDRLRule(@NonNull String ruleText) {
        try {
            this.defineDRLResource(ruleText);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new TargetSWRLRuleEngineInternalException("internal error generating Drools rule \n" + ruleText + "\n" + (e.getMessage() != null ? e.getMessage() : ""), (Throwable)e);
        }
        if (this.knowledgeBuilder.hasErrors()) {
            throw new TargetSWRLRuleEngineInternalException("internal error generating Drools rule\n" + ruleText + "\n" + this.knowledgeBuilder.getErrors().toString());
        }
    }

    private void defineGlobalJavaObjects() {
        this.defineDRLResource("import org.swrlapi.drools.reasoner.DroolsOWLAxiomHandler;");
        this.defineDRLResource("global DroolsOWLAxiomHandler inferrer;");
        this.defineDRLResource("import org.swrlapi.drools.sqwrl.DroolsSQWRLCollectionHandler;");
        this.defineDRLResource("global DroolsSQWRLCollectionHandler sqwrlInferrer;");
        this.defineDRLResource("import org.swrlapi.drools.core.DroolsSWRLBuiltInInvoker;");
        this.defineDRLResource("global DroolsSWRLBuiltInInvoker invoker;");
    }

    private void importOWLAndSWRLJavaClasses() {
        this.importCoreOWLJavaClasses();
        this.importOWLClassExpressionJavaClasses();
        this.importOWLAxiomJavaClasses();
        this.importOWLDataRangeJavaClasses();
        this.importSWRLJavaClasses();
        this.importSQWRLJavaClasses();
    }

    private void importSQWRLJavaClasses() {
        this.defineDRLResource("import org.swrlapi.drools.sqwrl.SQWRLC");
        this.defineDRLResource("import org.swrlapi.drools.sqwrl.VPATH");
    }

    private void importSWRLJavaClasses() {
        this.defineDRLResource("import org.swrlapi.drools.swrl.BA");
        this.defineDRLResource("import org.swrlapi.drools.swrl.BAP");
        this.defineDRLResource("import org.swrlapi.drools.swrl.UBA");
        this.defineDRLResource("import org.swrlapi.drools.swrl.BAVNs");
    }

    private void importOWLDataRangeJavaClasses() {
        this.defineDRLResource("import org.swrlapi.drools.owl.dataranges.DR");
        this.defineDRLResource("import org.swrlapi.drools.owl.dataranges.DIO");
        this.defineDRLResource("import org.swrlapi.drools.owl.dataranges.DCO");
        this.defineDRLResource("import org.swrlapi.drools.owl.dataranges.DUO");
        this.defineDRLResource("import org.swrlapi.drools.owl.dataranges.DOO");
    }

    private void importOWLAxiomJavaClasses() {
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.AOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.CAA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.CDA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DCA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DDPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DIA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DJOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DJDPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DPAA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DPDA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.ECA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.EDPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.EOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.FDPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.FOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.IDA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.IOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.IFOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.IROPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.OPAA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.OPDA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.DPRA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.OPRA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.SCA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.SDPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.SIA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.SOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.SPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.TOPA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.NOPAA");
        this.defineDRLResource("import org.swrlapi.drools.owl.axioms.NDPAA");
    }

    private void importOWLClassExpressionJavaClasses() {
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.CE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OCOCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OIOCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OOOCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OUOCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OHVCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.DHVCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OSVFCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.DSVFCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OAVFCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.DAVFCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OMaxCCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.DMaxCCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OMaxCCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OMaxQCCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.DMaxQCCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.DMinCCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OECCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.DECCE");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.OOHSCE");
    }

    private void importCoreOWLJavaClasses() {
        this.defineDRLResource("import org.swrlapi.drools.owl.literals.L");
        this.defineDRLResource("import org.swrlapi.drools.owl.classes.C");
        this.defineDRLResource("import org.swrlapi.drools.owl.individuals.I");
        this.defineDRLResource("import org.swrlapi.drools.owl.properties.OP");
        this.defineDRLResource("import org.swrlapi.drools.owl.properties.DP");
        this.defineDRLResource("import org.swrlapi.drools.owl.properties.AP");
        this.defineDRLResource("import org.swrlapi.drools.owl.dataranges.D");
    }

    private void defineDRLResource(@NonNull String resourceText) {
        this.knowledgeBuilder.add(this.createDRLResource(resourceText), ResourceType.DRL);
    }

    private @NonNull Resource createDRLResource(@NonNull String resourceText) {
        Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(resourceText));
        if (resource != null) {
            return resource;
        }
        throw new TargetSWRLRuleEngineInternalException("internal error generating Drools resource: " + resourceText);
    }
}

