/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsSWRLBuiltInArgument2BAConverter;
import org.swrlapi.drools.extractors.DroolsSWRLBuiltInArgumentExtractor;
import org.swrlapi.drools.sqwrl.VPATH;
import org.swrlapi.drools.swrl.BA;
import org.swrlapi.drools.swrl.BAP;
import org.swrlapi.drools.swrl.BAVNs;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLBuiltInMethodRuntimeException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;

public class DroolsSWRLBuiltInInvoker {
    private final @NonNull SWRLRuleEngineBridge bridge;
    private final @NonNull DroolsSWRLBuiltInArgument2BAConverter builtInArgumentConvertor;
    private final @NonNull DroolsSWRLBuiltInArgumentExtractor builtInArgumentExtractor;
    public static final int MAX_BUILTIN_ARGUMENTS = 11;
    private final @NonNull Map<@NonNull String, @NonNull List<@NonNull List<@NonNull SWRLBuiltInArgument>>> invocationPatternMap;

    public DroolsSWRLBuiltInInvoker(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler) {
        this.bridge = bridge;
        this.builtInArgumentConvertor = new DroolsSWRLBuiltInArgument2BAConverter(bridge, droolsOWLClassExpressionHandler);
        this.builtInArgumentExtractor = new DroolsSWRLBuiltInArgumentExtractor(bridge, droolsOWLClassExpressionHandler, droolsOWLPropertyExpressionHandler);
        this.invocationPatternMap = new HashMap<String, List<List<SWRLBuiltInArgument>>>();
    }

    public void reset() {
        this.invocationPatternMap.clear();
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, @NonNull BA ba7) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, @NonNull BA ba7) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, @NonNull BA ba7, @NonNull BA ba8) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, BA ba7, @NonNull BA ba8) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, @NonNull BA ba7, @NonNull BA ba8, @NonNull BA ba9) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        bas.add(ba9);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, BA ba7, @NonNull BA ba8, @NonNull BA ba9) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        bas.add(ba9);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, @NonNull BA ba7, @NonNull BA ba8, @NonNull BA ba9, @NonNull BA ba10) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        bas.add(ba9);
        bas.add(ba10);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, BA ba7, @NonNull BA ba8, @NonNull BA ba9, @NonNull BA ba10) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        bas.add(ba9);
        bas.add(ba10);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, @NonNull BA ba7, @NonNull BA ba8, @NonNull BA ba9, @NonNull BA ba10, @NonNull BA ba11) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        bas.add(ba9);
        bas.add(ba10);
        bas.add(ba11);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, new VPATH(), new BAVNs(), bas);
    }

    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs bavns, @NonNull BA ba1, @NonNull BA ba2, @NonNull BA ba3, @NonNull BA ba4, @NonNull BA ba5, @NonNull BA ba6, BA ba7, @NonNull BA ba8, @NonNull BA ba9, @NonNull BA ba10, @NonNull BA ba11) {
        ArrayList<@NonNull BA> bas = new ArrayList<BA>();
        bas.add(ba1);
        bas.add(ba2);
        bas.add(ba3);
        bas.add(ba4);
        bas.add(ba5);
        bas.add(ba6);
        bas.add(ba7);
        bas.add(ba8);
        bas.add(ba9);
        bas.add(ba10);
        bas.add(ba11);
        return this.invoke(ruleName, builtInName, builtInIndex, isInConsequent, vpath, bavns, bas);
    }

    private String createInvocationPattern(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull List<@NonNull SWRLBuiltInArgument> vPathArguments, @NonNull List<@NonNull SWRLBuiltInArgument> builtInrguments) {
        StringBuilder sb = new StringBuilder();
        sb.append(ruleName).append(".");
        sb.append(builtInName).append(".");
        sb.append("").append(builtInIndex).append(".");
        sb.append("").append(isInConsequent);
        for (SWRLBuiltInArgument vPathArgument : vPathArguments) {
            sb.append(".").append(vPathArgument.toString());
        }
        for (SWRLBuiltInArgument builtInArgument : builtInrguments) {
            sb.append(".").append(builtInArgument.toString());
        }
        return sb.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull BAP> invoke(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull VPATH vpath, @NonNull BAVNs argumentVariableNames, @NonNull List<@NonNull BA> bas) {
        List<@NonNull SWRLBuiltInArgument> builtInArguments = this.bas2SWRLBuiltInArguments(ruleName, builtInName, argumentVariableNames, bas);
        List<@NonNull SWRLBuiltInArgument> vPathArguments = this.vpath2SWRLBuiltInArguments(ruleName, builtInName, vpath);
        try {
            String invocationPattern = this.createInvocationPattern(ruleName, builtInName, builtInIndex, isInConsequent, vPathArguments, builtInArguments);
            if (!isInConsequent && this.hasInvocationPattern(invocationPattern)) {
                List<@NonNull List<@NonNull SWRLBuiltInArgument>> argumentPatterns = this.getInvocationPatternArguments(ruleName, builtInName, invocationPattern);
                return this.swrlBuiltInArgumentPatterns2BAPs(ruleName, builtInName, argumentPatterns);
            }
            @NonNull @NonNull List argumentPatterns = this.getBridge().invokeSWRLBuiltIn(ruleName, builtInName, builtInIndex, isInConsequent, builtInArguments);
            if (!isInConsequent) {
                this.addInvocationPattern(builtInName, invocationPattern, argumentPatterns);
            }
            return this.swrlBuiltInArgumentPatterns2BAPs(ruleName, builtInName, argumentPatterns);
        }
        catch (Throwable e) {
            if (e instanceof SWRLBuiltInMethodRuntimeException) {
                Throwable cause = e.getCause();
                throw new SWRLAPIException("runtime exception thrown by built-in " + builtInName + " in rule " + ruleName + ": " + (cause != null ? cause.toString() : ""), cause);
            }
            if (e instanceof SWRLBuiltInException) {
                throw new SWRLAPIException("built-in exception thrown by built-in " + builtInName + " in rule " + ruleName + ": " + (e != null ? e.getMessage() : ""), e);
            }
            throw new SWRLAPIException("unknown exception " + e.getClass().getCanonicalName() + " thrown by built-in " + builtInName + " in rule " + ruleName + ": " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private @NonNull List<@NonNull SWRLBuiltInArgument> bas2SWRLBuiltInArguments(@NonNull String ruleName, @NonNull String builtInName, @NonNull BAVNs argumentVariableNames, @NonNull List<@NonNull BA> bas) {
        ArrayList<@NonNull SWRLBuiltInArgument> arguments = new ArrayList<SWRLBuiltInArgument>();
        if (argumentVariableNames.hasVariableNames() && argumentVariableNames.getNumberOfArguments() != bas.size()) {
            throw new TargetSWRLRuleEngineInternalException("inconsistent variable names passed to built-in " + builtInName + " in rule " + ruleName);
        }
        try {
            int argumentNumber = 0;
            for (BA ba : bas) {
                SWRLBuiltInArgument argument = ba.extract(this.getSWRLAtomArgumentExtractor());
                if (argumentVariableNames.hasVariableNames() && argumentVariableNames.getVariableNames().get(argumentNumber).length() != 0) {
                    String variableName = argumentVariableNames.getVariableNames().get(argumentNumber);
                    argument.setBoundVariableName(variableName);
                }
                arguments.add(argument);
                ++argumentNumber;
            }
        }
        catch (TargetSWRLRuleEngineException e) {
            throw new TargetSWRLRuleEngineInternalException("error extracting arguments from Drools when invoking built-in " + builtInName + " in rule " + ruleName + ": " + e.toString());
        }
        return arguments;
    }

    private @NonNull List<@NonNull SWRLBuiltInArgument> vpath2SWRLBuiltInArguments(@NonNull String ruleName, @NonNull String builtInName, @NonNull VPATH vpath) {
        ArrayList<@NonNull SWRLBuiltInArgument> arguments = new ArrayList<SWRLBuiltInArgument>();
        try {
            for (BA ba : vpath.getArguments()) {
                SWRLBuiltInArgument argument = ba.extract(this.getSWRLAtomArgumentExtractor());
                arguments.add(argument);
            }
        }
        catch (TargetSWRLRuleEngineException e) {
            throw new TargetSWRLRuleEngineInternalException("error extracting path arguments from Drools when invoking built-in " + builtInName + " in rule " + ruleName + ": " + e.toString());
        }
        return arguments;
    }

    private @NonNull List<@NonNull BAP> swrlBuiltInArgumentPatterns2BAPs(@NonNull String ruleName, @NonNull String builtInName, @NonNull List<@NonNull List<@NonNull SWRLBuiltInArgument>> argumentPatterns) throws SWRLBuiltInException {
        ArrayList<@NonNull BAP> baps = new ArrayList<BAP>();
        try {
            for (List<SWRLBuiltInArgument> argumentPattern : argumentPatterns) {
                BAP bap = new BAP();
                for (SWRLBuiltInArgument argument : argumentPattern) {
                    BA ba;
                    Optional builtInResult;
                    if (argument.isVariable() && argument.asVariable().hasBuiltInResult() && (builtInResult = argument.asVariable().getBuiltInResult()).isPresent()) {
                        argument = (SWRLBuiltInArgument)builtInResult.get();
                    }
                    if ((ba = this.getSWRLBuiltInArgumentConverter().convert(argument)) == null) {
                        throw new TargetSWRLRuleEngineInternalException("error converting return argument " + argument + " after invoking built-in " + builtInName + " in rule " + ruleName);
                    }
                    bap.addArgument(ba);
                }
                baps.add(bap);
            }
        }
        catch (RuntimeException e) {
            throw new TargetSWRLRuleEngineInternalException("error converting return arguments after invoking built-in " + builtInName + " in rule " + ruleName + ": " + e.toString());
        }
        return baps;
    }

    private boolean hasInvocationPattern(@NonNull String invocationPattern) {
        return this.invocationPatternMap.containsKey(invocationPattern);
    }

    private void addInvocationPattern(@NonNull String builtInName, @NonNull String invocationPattern, List<@NonNull List<@NonNull SWRLBuiltInArgument>> argumentPatterns) {
        if (this.invocationPatternMap.containsKey(invocationPattern)) {
            throw new TargetSWRLRuleEngineInternalException("inconsistent invocation pattern in " + builtInName + " in rule");
        }
        this.invocationPatternMap.put(invocationPattern, argumentPatterns);
    }

    private List<@NonNull List<@NonNull SWRLBuiltInArgument>> getInvocationPatternArguments(@NonNull String ruleName, @NonNull String builtInName, @NonNull String invocationPattern) {
        if (this.invocationPatternMap.containsKey(invocationPattern)) {
            return this.invocationPatternMap.get(invocationPattern);
        }
        throw new TargetSWRLRuleEngineInternalException("unknown invocation pattern in " + builtInName + " in rule " + ruleName);
    }

    private @NonNull DroolsSWRLBuiltInArgument2BAConverter getSWRLBuiltInArgumentConverter() {
        return this.builtInArgumentConvertor;
    }

    private @NonNull DroolsSWRLBuiltInArgumentExtractor getSWRLAtomArgumentExtractor() {
        return this.builtInArgumentExtractor;
    }

    private @NonNull SWRLRuleEngineBridge getBridge() {
        return this.bridge;
    }
}

