/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.core;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.TargetSWRLRuleEngine;
import org.swrlapi.drools.converters.drl.DroolsSQWRLQuery2DRLConverter;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLAxiom2AConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLIndividual2IConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLLiteral2LConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.core.DroolsResourceHandler;
import org.swrlapi.drools.core.DroolsRuleDefinition;
import org.swrlapi.drools.core.DroolsSWRLBuiltInInvoker;
import org.swrlapi.drools.extractors.DroolsOWLAxiomExtractor;
import org.swrlapi.drools.factory.DroolsFactory;
import org.swrlapi.drools.owl.axioms.A;
import org.swrlapi.drools.owl2rl.DroolsOWL2RLEngine;
import org.swrlapi.drools.reasoner.DefaultDroolsOWLAxiomHandler;
import org.swrlapi.drools.sqwrl.DroolsSQWRLCollectionHandler;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLRuleEngineBridgeException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;
import org.swrlapi.owl2rl.OWL2RLEngine;
import org.swrlapi.sqwrl.SQWRLQuery;

public class DroolsSWRLRuleEngine
implements TargetSWRLRuleEngine {
    private final @NonNull SWRLRuleEngineBridge bridge;
    private final @NonNull DroolsOWLAxiom2AConverter axiom2AConverter;
    private final @NonNull DroolsSQWRLQuery2DRLConverter sqwrlQuery2DRLConverter;
    private final @NonNull DroolsOWLAxiomExtractor axiomExtractor;
    private final @NonNull DroolsSWRLBuiltInInvoker builtInInvoker;
    private final @NonNull DroolsSQWRLCollectionHandler sqwrlCollectionHandler;
    private final @NonNull DroolsOWL2RLEngine owl2RLEngine;
    private final @NonNull DefaultDroolsOWLAxiomHandler axiomInferrer;
    private final @NonNull DroolsOWLClassExpressionHandler classExpressionHandler;
    private final @NonNull DroolsOWLPropertyExpressionHandler propertyExpressionHandler;
    private final @NonNull DroolsOWLDataRangeHandler dataRangeHandler;
    private final @NonNull Set<@NonNull OWLAxiom> assertedAndInferredOWLAxioms;
    private final @NonNull Set<@NonNull String> allSQWRLQueryNames;
    private final @NonNull Set<@NonNull String> activeSQWRLQueryNames;
    private final @NonNull Set<@NonNull String> phase1SQWRLRuleNames;
    private final @NonNull Set<@NonNull String> phase2SQWRLRuleNames;
    private final @NonNull Map<@NonNull String, String> ruleName2SQWRLQueryNameMap;
    private final @NonNull SQWRLPhase1AgendaFilter sqwrlPhase1AgendaFilter;
    private final @NonNull SQWRLPhase2AgendaFilter sqwrlPhase2AgendaFilter;
    private KnowledgeBase knowledgeBase;
    private KnowledgeBuilder knowledgeBuilder;
    private StatefulKnowledgeSession knowledgeSession;
    private DroolsResourceHandler resourceHandler;
    private boolean ruleLoadRequired;

    public DroolsSWRLRuleEngine(@NonNull SWRLRuleEngineBridge bridge) throws TargetSWRLRuleEngineException {
        this.bridge = bridge;
        DroolsOWLIndividual2IConverter droolsOWLIndividual2IConverter = new DroolsOWLIndividual2IConverter(bridge);
        DroolsOWLLiteral2LConverter droolsOWLLiteral2LConverter = new DroolsOWLLiteral2LConverter(bridge);
        this.propertyExpressionHandler = new DroolsOWLPropertyExpressionHandler(bridge);
        this.dataRangeHandler = new DroolsOWLDataRangeHandler(bridge);
        this.classExpressionHandler = new DroolsOWLClassExpressionHandler(bridge, droolsOWLIndividual2IConverter, this.propertyExpressionHandler, this.dataRangeHandler, droolsOWLLiteral2LConverter);
        this.axiom2AConverter = new DroolsOWLAxiom2AConverter(bridge, this, this.classExpressionHandler, this.propertyExpressionHandler, this.dataRangeHandler);
        this.sqwrlQuery2DRLConverter = new DroolsSQWRLQuery2DRLConverter(bridge, this, this.classExpressionHandler, this.propertyExpressionHandler, this.dataRangeHandler);
        this.axiomExtractor = DroolsFactory.getDroolsOWLAxiomExtractor(bridge, this.classExpressionHandler, this.propertyExpressionHandler, this.dataRangeHandler);
        this.builtInInvoker = new DroolsSWRLBuiltInInvoker(bridge, this.classExpressionHandler, this.propertyExpressionHandler);
        this.owl2RLEngine = new DroolsOWL2RLEngine(bridge.getOWL2RLPersistenceLayer());
        this.axiomInferrer = new DefaultDroolsOWLAxiomHandler();
        this.sqwrlCollectionHandler = new DroolsSQWRLCollectionHandler();
        this.assertedAndInferredOWLAxioms = new HashSet<OWLAxiom>();
        this.allSQWRLQueryNames = new HashSet<String>();
        this.activeSQWRLQueryNames = new HashSet<String>();
        this.phase1SQWRLRuleNames = new HashSet<String>();
        this.phase2SQWRLRuleNames = new HashSet<String>();
        this.ruleName2SQWRLQueryNameMap = new HashMap<String, String>();
        this.sqwrlPhase1AgendaFilter = new SQWRLPhase1AgendaFilter();
        this.sqwrlPhase2AgendaFilter = new SQWRLPhase2AgendaFilter();
        this.knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)DroolsSWRLRuleEngine.createKnowledgeBaseConfiguration());
        this.knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        this.resourceHandler = new DroolsResourceHandler(this.knowledgeBuilder);
        this.resourceHandler.defineJavaResources();
        DroolsSWRLRuleEngine.addKnowledgePackages(this.knowledgeBase, this.knowledgeBuilder);
        for (DroolsRuleDefinition ruleDefinition : this.owl2RLEngine.getEnabledRuleDefinitions()) {
            this.resourceHandler.defineDRLRule(ruleDefinition.getRuleText());
        }
        this.ruleLoadRequired = true;
        this.builtInInvoker.reset();
        this.knowledgeSession = this.knowledgeBase.newStatefulKnowledgeSession();
        this.knowledgeSession.setGlobal("invoker", (Object)this.builtInInvoker);
        this.knowledgeSession.setGlobal("inferrer", (Object)this.axiomInferrer);
        this.knowledgeSession.setGlobal("sqwrlInferrer", (Object)this.sqwrlCollectionHandler);
        this.axiomInferrer.reset(this.knowledgeSession);
    }

    public void resetRuleEngine() throws TargetSWRLRuleEngineException {
        if (this.getBridge().hasOntologyChanged() || this.getOWL2RLEngine().hasRuleSelectionChanged()) {
            this.knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)DroolsSWRLRuleEngine.createKnowledgeBaseConfiguration());
            this.knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            this.resourceHandler = new DroolsResourceHandler(this.knowledgeBuilder);
            this.resourceHandler.defineJavaResources();
            DroolsSWRLRuleEngine.addKnowledgePackages(this.knowledgeBase, this.knowledgeBuilder);
            for (DroolsRuleDefinition ruleDefinition : this.owl2RLEngine.getEnabledRuleDefinitions()) {
                this.resourceHandler.defineDRLRule(ruleDefinition.getRuleText());
            }
            this.ruleLoadRequired = true;
        }
        this.builtInInvoker.reset();
        this.axiom2AConverter.reset();
        this.classExpressionHandler.reset();
        this.propertyExpressionHandler.reset();
        this.dataRangeHandler.reset();
        this.resetKnowledgeSession();
    }

    public void runRuleEngine() throws TargetSWRLRuleEngineException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DroolsSWRLRuleEngine.class.getClassLoader());
        if (this.ruleLoadRequired) {
            try {
                this.knowledgeBase.addKnowledgePackages(this.knowledgeBuilder.getKnowledgePackages());
            }
            catch (Exception e) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                throw new TargetSWRLRuleEngineException("error transferring rules to Drools rule engine:\n" + e.getMessage(), (Throwable)e);
            }
            this.ruleLoadRequired = false;
        }
        try {
            this.getDroolsOWLAxiom2AConverter().getAssertedOWLAxioms().forEach(arg_0 -> ((StatefulKnowledgeSession)this.knowledgeSession).insert(arg_0));
            this.getDroolsOWLAxiom2AConverter().getOWLClassExpressions().forEach(arg_0 -> ((StatefulKnowledgeSession)this.knowledgeSession).insert(arg_0));
        }
        catch (Exception e) {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            String errorMessage = this.buildChainedErrorMessage(e);
            throw new TargetSWRLRuleEngineException("error inserting asserted OWL axioms into Drools:\n" + errorMessage, (Throwable)e);
        }
        this.axiomInferrer.addAssertOWLAxioms(this.getDroolsOWLAxiom2AConverter().getAssertedOWLAxioms());
        try {
            this.knowledgeSession.fireAllRules((AgendaFilter)this.sqwrlPhase1AgendaFilter);
            if (!this.phase2SQWRLRuleNames.isEmpty() && this.sqwrlCollectionHandler.hasSQWRLCollections()) {
                this.sqwrlCollectionHandler.getSQWRLCollections().forEach(arg_0 -> ((StatefulKnowledgeSession)this.knowledgeSession).insert(arg_0));
                this.knowledgeSession.fireAllRules((AgendaFilter)this.sqwrlPhase2AgendaFilter);
            }
        }
        catch (Exception e) {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            String errorMessage = this.getInvocationTargetCause(e);
            throw new TargetSWRLRuleEngineException("error running Drools rule engine:\n" + errorMessage, (Throwable)e);
        }
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        this.writeInferredOWLAxiomsToBridge();
    }

    public void defineOWLAxiom(@NonNull OWLAxiom axiom) throws TargetSWRLRuleEngineException {
        if (!this.assertedAndInferredOWLAxioms.contains(axiom)) {
            this.getDroolsOWLAxiom2AConverter().convert(axiom);
            this.assertedAndInferredOWLAxioms.add(axiom);
            if (axiom.isOfType(new AxiomType[]{AxiomType.SWRL_RULE})) {
                this.ruleLoadRequired = true;
            }
        }
    }

    public void defineSQWRLQuery(@NonNull SQWRLQuery query) throws TargetSWRLRuleEngineException, SWRLBuiltInException {
        this.allSQWRLQueryNames.add(query.getQueryName());
        if (query.isActive()) {
            this.activeSQWRLQueryNames.add(query.getQueryName());
            this.ruleLoadRequired = true;
        }
        this.getDroolsSQWRLQuery2DRLConverter().convert(query);
    }

    public @NonNull OWLReasoner getOWLReasoner() {
        throw new RuntimeException("reasoner not yet wired up");
    }

    public @NonNull Icon getTargetRuleEngineIcon() {
        return DroolsFactory.getSWRLRuleEngineIcon();
    }

    public @NonNull OWL2RLEngine getOWL2RLEngine() {
        return this.owl2RLEngine;
    }

    public @NonNull String getTargetRuleEngineName() {
        return "Drools";
    }

    public @NonNull String getTargetRuleEngineVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public void defineDRLRule(@NonNull String ruleText) {
        if (this.ruleLoadRequired) {
            this.resourceHandler.defineDRLRule(ruleText);
        }
    }

    public void defineDRLSQWRLPhase1Rule(@NonNull String queryName, @NonNull String ruleName, @NonNull String ruleText) throws TargetSWRLRuleEngineException {
        this.phase1SQWRLRuleNames.add(ruleName);
        this.ruleName2SQWRLQueryNameMap.put(ruleName, queryName);
        if (this.ruleLoadRequired) {
            this.defineDRLRule(ruleText);
        }
    }

    public void defineDRLSQWRLPhase2Rule(@NonNull String queryName, @NonNull String ruleName, @NonNull String ruleText) throws TargetSWRLRuleEngineException {
        this.phase2SQWRLRuleNames.add(ruleName);
        this.ruleName2SQWRLQueryNameMap.put(ruleName, queryName);
        if (this.ruleLoadRequired) {
            this.defineDRLRule(ruleText);
        }
    }

    private void resetKnowledgeSession() {
        if (this.knowledgeSession != null) {
            this.knowledgeSession.dispose();
        }
        this.knowledgeSession = this.knowledgeBase.newStatefulKnowledgeSession();
        this.knowledgeSession.setGlobal("invoker", (Object)this.builtInInvoker);
        this.knowledgeSession.setGlobal("inferrer", (Object)this.axiomInferrer);
        this.knowledgeSession.setGlobal("sqwrlInferrer", (Object)this.sqwrlCollectionHandler);
        this.axiomInferrer.reset(this.knowledgeSession);
        this.sqwrlCollectionHandler.reset();
        this.assertedAndInferredOWLAxioms.clear();
        this.allSQWRLQueryNames.clear();
        this.activeSQWRLQueryNames.clear();
        this.phase1SQWRLRuleNames.clear();
        this.phase2SQWRLRuleNames.clear();
        this.ruleName2SQWRLQueryNameMap.clear();
        this.axiom2AConverter.reset();
        this.sqwrlQuery2DRLConverter.reset();
    }

    private void writeInferredOWLAxiomsToBridge() throws TargetSWRLRuleEngineException {
        try {
            for (A a : this.axiomInferrer.getInferredOWLAxioms()) {
                OWLAxiom axiom = a.extract(this.getDroolsOWLAxiomExtractor());
                this.getBridge().inferOWLAxiom(axiom);
            }
        }
        catch (SWRLRuleEngineBridgeException e) {
            throw new TargetSWRLRuleEngineException("error writing inferred OWL axioms to bridge: " + (e.getMessage() != null ? e.getMessage() : ""), (Throwable)e);
        }
    }

    private static void addKnowledgePackages(@NonNull KnowledgeBase knowledgeBase, @NonNull KnowledgeBuilder knowledgeBuilder) throws TargetSWRLRuleEngineException {
        if (knowledgeBuilder.hasErrors()) {
            throw new TargetSWRLRuleEngineException("error configuring Drools rule engine: " + knowledgeBuilder.getErrors().toString());
        }
        try {
            knowledgeBase.addKnowledgePackages(knowledgeBuilder.getKnowledgePackages());
        }
        catch (Exception e) {
            throw new TargetSWRLRuleEngineException("error configuring Drools rule engine: " + (e.getMessage() != null ? e.getMessage() : ""), (Throwable)e);
        }
    }

    private static KieBaseConfiguration createKnowledgeBaseConfiguration() {
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setProperty("drools.assertBehaviour", "equality");
        config.setProperty("drools.dialect.mvel.strict", "false");
        return config;
    }

    private @NonNull String getInvocationTargetCause(Throwable t) {
        String message = t.getMessage() != null ? t.getMessage() : "";
        for (Throwable currentThrowable = t; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            InvocationTargetException invocationTargetException;
            Throwable targetException;
            if (!(currentThrowable instanceof InvocationTargetException) || (targetException = (invocationTargetException = (InvocationTargetException)currentThrowable).getTargetException()).getMessage() == null) continue;
            message = message + ": " + targetException.getMessage();
        }
        return message;
    }

    private @NonNull String buildChainedErrorMessage(Throwable t) {
        String message = t.getMessage() != null ? t.getMessage() : "";
        Throwable currentThrowable = t;
        while (currentThrowable != null) {
            Throwable cause = currentThrowable.getCause();
            if (cause != null && cause.getMessage() != null) {
                message = message + ": " + cause.getMessage();
            }
            currentThrowable = cause;
        }
        return message;
    }

    private @NonNull SWRLRuleEngineBridge getBridge() {
        return this.bridge;
    }

    private @NonNull DroolsOWLAxiom2AConverter getDroolsOWLAxiom2AConverter() {
        return this.axiom2AConverter;
    }

    private @NonNull DroolsOWLAxiomExtractor getDroolsOWLAxiomExtractor() {
        return this.axiomExtractor;
    }

    private @NonNull DroolsSQWRLQuery2DRLConverter getDroolsSQWRLQuery2DRLConverter() {
        return this.sqwrlQuery2DRLConverter;
    }

    private class SQWRLPhase2AgendaFilter
    implements AgendaFilter {
        private SQWRLPhase2AgendaFilter() {
        }

        public boolean accept(Match activation) {
            String ruleName = activation.getRule().getName();
            if (DroolsSWRLRuleEngine.this.phase2SQWRLRuleNames.contains(ruleName)) {
                if (DroolsSWRLRuleEngine.this.ruleName2SQWRLQueryNameMap.containsKey(ruleName)) {
                    String sqwrlQueryName = (String)DroolsSWRLRuleEngine.this.ruleName2SQWRLQueryNameMap.get(ruleName);
                    return DroolsSWRLRuleEngine.this.activeSQWRLQueryNames.contains(sqwrlQueryName);
                }
                throw new TargetSWRLRuleEngineInternalException("phase 2 rule " + ruleName + " not correctly recorded as SQWRL query");
            }
            return false;
        }
    }

    private class SQWRLPhase1AgendaFilter
    implements AgendaFilter {
        private SQWRLPhase1AgendaFilter() {
        }

        public boolean accept(Match activation) {
            String ruleName = activation.getRule().getName();
            if (DroolsSWRLRuleEngine.this.phase1SQWRLRuleNames.contains(ruleName)) {
                if (DroolsSWRLRuleEngine.this.ruleName2SQWRLQueryNameMap.containsKey(ruleName)) {
                    String sqwrlQueryName = (String)DroolsSWRLRuleEngine.this.ruleName2SQWRLQueryNameMap.get(ruleName);
                    return DroolsSWRLRuleEngine.this.activeSQWRLQueryNames.contains(sqwrlQueryName);
                }
                throw new TargetSWRLRuleEngineInternalException("phase 1 SQWRL rule " + ruleName + " not correctly recorded as query");
            }
            return !DroolsSWRLRuleEngine.this.phase2SQWRLRuleNames.contains(ruleName);
        }
    }
}

