/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.extractors;

import java.net.URI;
import java.net.URISyntaxException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.extractors.TargetRuleEngineExtractorBase;
import org.swrlapi.bridge.extractors.TargetRuleEngineOWLLiteralExtractor;
import org.swrlapi.drools.owl.literals.L;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

public class DroolsOWLLiteralExtractor
extends TargetRuleEngineExtractorBase
implements TargetRuleEngineOWLLiteralExtractor<L> {
    public DroolsOWLLiteralExtractor(SWRLRuleEngineBridge bridge) {
        super(bridge);
    }

    public @NonNull OWLLiteral extract(@NonNull L l) {
        try {
            if (l.isString()) {
                return this.getOWLLiteralFactory().getOWLLiteral(l.getValue());
            }
            if (l.isAnyURI()) {
                return this.getOWLLiteralFactory().getOWLLiteral(new URI(l.getValue()));
            }
            if (l.isBoolean()) {
                return this.getOWLLiteralFactory().getOWLLiteral(Boolean.valueOf(l.getValue()).booleanValue());
            }
            if (l.isByte()) {
                return this.getOWLLiteralFactory().getOWLLiteral(Byte.valueOf(l.getValue()).byteValue());
            }
            if (l.isShort()) {
                return this.getOWLLiteralFactory().getOWLLiteral(Short.valueOf(l.getValue()).shortValue());
            }
            if (l.isInt()) {
                return this.getOWLLiteralFactory().getOWLLiteral(Integer.valueOf(l.getValue()).intValue());
            }
            if (l.isLong()) {
                return this.getOWLLiteralFactory().getOWLLiteral(Long.valueOf(l.getValue()).longValue());
            }
            if (l.isFloat()) {
                return this.getOWLLiteralFactory().getOWLLiteral(Float.valueOf(l.getValue()).floatValue());
            }
            if (l.isDouble()) {
                return this.getOWLLiteralFactory().getOWLLiteral(Double.valueOf(l.getValue()).doubleValue());
            }
            if (l.isTime()) {
                return this.getOWLLiteralFactory().getOWLLiteral(new XSDTime(l.getValue()));
            }
            if (l.isDate()) {
                return this.getOWLLiteralFactory().getOWLLiteral(new XSDDate(l.getValue()));
            }
            if (l.isDateTime()) {
                return this.getOWLLiteralFactory().getOWLLiteral(new XSDDateTime(l.getValue()));
            }
            if (l.isDuration()) {
                return this.getOWLLiteralFactory().getOWLLiteral(new XSDDuration(l.getValue()));
            }
            IRI IRI2 = this.prefixedName2IRI(l.datatypeName);
            OWLDatatype datatype = this.getOWLDatatypeFactory().getOWLDatatype(IRI2);
            return this.getOWLLiteralFactory().getOWLLiteral(l.value, datatype);
        }
        catch (NumberFormatException e) {
            throw new TargetSWRLRuleEngineInternalException("number format exception extracting OWL literal " + l + " with type " + l.getTypeName() + " from Drools: ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new TargetSWRLRuleEngineInternalException("IRI exception extracting OWL URI literal " + l + " from Drools: ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TargetSWRLRuleEngineInternalException("exception extracting OWL literal " + l + " with type " + l.getTypeName() + " from Drools: " + (e.getMessage() != null ? e.getMessage() : ""), (Throwable)e);
        }
    }
}

