/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.extractors;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.extractors.TargetRuleEngineSWRLBuiltInArgumentExtractor;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.extractors.DroolsExtractorBase;
import org.swrlapi.drools.owl.classes.C;
import org.swrlapi.drools.owl.classes.CE;
import org.swrlapi.drools.owl.dataranges.D;
import org.swrlapi.drools.owl.individuals.I;
import org.swrlapi.drools.owl.literals.L;
import org.swrlapi.drools.owl.properties.AP;
import org.swrlapi.drools.owl.properties.DP;
import org.swrlapi.drools.owl.properties.DPE;
import org.swrlapi.drools.owl.properties.OP;
import org.swrlapi.drools.owl.properties.OPE;
import org.swrlapi.drools.sqwrl.SQWRLC;
import org.swrlapi.drools.swrl.UBA;
import org.swrlapi.drools.swrl.VA;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;

public class DroolsSWRLBuiltInArgumentExtractor
extends DroolsExtractorBase
implements TargetRuleEngineSWRLBuiltInArgumentExtractor {
    private final @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;

    public DroolsSWRLBuiltInArgumentExtractor(SWRLRuleEngineBridge bridge, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler) {
        super(bridge);
        this.droolsOWLClassExpressionHandler = droolsOWLClassExpressionHandler;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
    }

    public @NonNull SWRLVariable extract(@NonNull VA va) throws TargetSWRLRuleEngineException {
        IRI iri = this.prefixedName2IRI(va.getVariableName());
        return this.getOWLDataFactory().getSWRLVariable(iri);
    }

    public @NonNull SWRLClassBuiltInArgument extract(C c) throws TargetSWRLRuleEngineException {
        OWLClass cls = this.getDroolsOWLEntityExtractor().extract(c);
        return this.getSWRLBuiltInArgumentFactory().getClassBuiltInArgument(cls);
    }

    public @NonNull SWRLClassExpressionBuiltInArgument extract(CE ce) throws TargetSWRLRuleEngineException {
        OWLClassExpression classExpression = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(ce.getceid());
        return this.getSWRLBuiltInArgumentFactory().getClassExpressionBuiltInArgument(classExpression);
    }

    public @NonNull SWRLNamedIndividualBuiltInArgument extract(I i) throws TargetSWRLRuleEngineException {
        OWLNamedIndividual individual = this.getDroolsOWLEntityExtractor().extract(i);
        return this.getSWRLBuiltInArgumentFactory().getNamedIndividualBuiltInArgument(individual);
    }

    public @NonNull SWRLObjectPropertyBuiltInArgument extract(OP op) throws TargetSWRLRuleEngineException {
        OWLObjectProperty property = this.getDroolsOWLEntityExtractor().extract(op);
        return this.getSWRLBuiltInArgumentFactory().getObjectPropertyBuiltInArgument(property);
    }

    public @NonNull SWRLObjectPropertyExpressionBuiltInArgument extract(OPE pe) throws TargetSWRLRuleEngineException {
        OWLObjectPropertyExpression propertyExpression = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(pe.getid());
        return this.getSWRLBuiltInArgumentFactory().getObjectPropertyExpressionBuiltInArgument(propertyExpression);
    }

    public @NonNull SWRLDataPropertyBuiltInArgument extract(DP dp) throws TargetSWRLRuleEngineException {
        OWLDataProperty property = this.getDroolsOWLEntityExtractor().extract(dp);
        return this.getSWRLBuiltInArgumentFactory().getDataPropertyBuiltInArgument(property);
    }

    public @NonNull SWRLDataPropertyExpressionBuiltInArgument extract(DPE pe) throws TargetSWRLRuleEngineException {
        OWLDataPropertyExpression propertyExpression = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(pe.getid());
        return this.getSWRLBuiltInArgumentFactory().getDataPropertyExpressionBuiltInArgument(propertyExpression);
    }

    public @NonNull SWRLAnnotationPropertyBuiltInArgument extract(AP ap) throws TargetSWRLRuleEngineException {
        OWLAnnotationProperty property = this.getDroolsOWLEntityExtractor().extract(ap);
        return this.getSWRLBuiltInArgumentFactory().getAnnotationPropertyBuiltInArgument(property);
    }

    public @NonNull SWRLDatatypeBuiltInArgument extract(D d) throws TargetSWRLRuleEngineException {
        OWLDatatype datatype = this.getDroolsOWLEntityExtractor().extract(d);
        return this.getSWRLBuiltInArgumentFactory().getDatatypeBuiltInArgument(datatype);
    }

    public @NonNull SWRLLiteralBuiltInArgument extract(@NonNull L l) throws TargetSWRLRuleEngineException {
        OWLLiteral literal = this.getDroolsOWLLiteralExtractor().extract(l);
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(literal);
    }

    public @NonNull SWRLVariableBuiltInArgument extract(@NonNull UBA uba) throws TargetSWRLRuleEngineException {
        String variableName = uba.getVariableName();
        IRI variableIRI = this.getDroolsSWRLVariableExtractor().variableName2VariableIRI(variableName);
        return this.getSWRLBuiltInArgumentFactory().getUnboundVariableBuiltInArgument(variableIRI);
    }

    public @NonNull SQWRLCollectionVariableBuiltInArgument extract(@NonNull SQWRLC sqwrlc) throws TargetSWRLRuleEngineException {
        String variableName = sqwrlc.getVariableName();
        IRI variableIRI = this.getDroolsSWRLVariableExtractor().variableName2VariableIRI(variableName);
        return this.getSWRLBuiltInArgumentFactory().getSQWRLCollectionVariableBuiltInArgument(variableIRI, sqwrlc.getQueryName(), sqwrlc.getCollectionName(), sqwrlc.getCollectionID());
    }

    private @NonNull DroolsOWLClassExpressionHandler getDroolsOWLClassExpressionHandler() {
        return this.droolsOWLClassExpressionHandler;
    }

    private @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }
}

