/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.factory;

import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.extractors.DroolsExtractorBase;
import org.swrlapi.drools.extractors.DroolsOWLAxiomExtractor;
import org.swrlapi.drools.owl.axioms.AOPA;
import org.swrlapi.drools.owl.axioms.APDA;
import org.swrlapi.drools.owl.axioms.CAA;
import org.swrlapi.drools.owl.axioms.CDA;
import org.swrlapi.drools.owl.axioms.DCA;
import org.swrlapi.drools.owl.axioms.DDPA;
import org.swrlapi.drools.owl.axioms.DIA;
import org.swrlapi.drools.owl.axioms.DJDPA;
import org.swrlapi.drools.owl.axioms.DJOPA;
import org.swrlapi.drools.owl.axioms.DOPA;
import org.swrlapi.drools.owl.axioms.DPAA;
import org.swrlapi.drools.owl.axioms.DPDA;
import org.swrlapi.drools.owl.axioms.DPRA;
import org.swrlapi.drools.owl.axioms.ECA;
import org.swrlapi.drools.owl.axioms.EDPA;
import org.swrlapi.drools.owl.axioms.EOPA;
import org.swrlapi.drools.owl.axioms.FDPA;
import org.swrlapi.drools.owl.axioms.FOPA;
import org.swrlapi.drools.owl.axioms.IDA;
import org.swrlapi.drools.owl.axioms.IFOPA;
import org.swrlapi.drools.owl.axioms.IOPA;
import org.swrlapi.drools.owl.axioms.IROPA;
import org.swrlapi.drools.owl.axioms.NDPAA;
import org.swrlapi.drools.owl.axioms.NOPAA;
import org.swrlapi.drools.owl.axioms.OPAA;
import org.swrlapi.drools.owl.axioms.OPDA;
import org.swrlapi.drools.owl.axioms.OPRA;
import org.swrlapi.drools.owl.axioms.SCA;
import org.swrlapi.drools.owl.axioms.SDPA;
import org.swrlapi.drools.owl.axioms.SIA;
import org.swrlapi.drools.owl.axioms.SOPA;
import org.swrlapi.drools.owl.axioms.SPA;
import org.swrlapi.drools.owl.axioms.TOPA;
import org.swrlapi.drools.owl.individuals.I;

class DefaultDroolsOWLAxiomExtractor
extends DroolsExtractorBase
implements DroolsOWLAxiomExtractor {
    private final @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;
    private final @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler;

    public DefaultDroolsOWLAxiomExtractor(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler) {
        super(bridge);
        this.droolsOWLClassExpressionHandler = droolsOWLClassExpressionHandler;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
        this.droolsOWLDataRangeHandler = droolsOWLDataRangeHandler;
    }

    @Override
    public @NonNull OWLDeclarationAxiom extract(@NonNull CDA da) {
        OWLClass cls = this.getOWLDataFactory().getOWLClass(this.prefixedName2IRI(da.getcid()));
        return this.getSWRLAPIOWLDataFactory().getOWLClassDeclarationAxiom(cls);
    }

    @Override
    public @NonNull OWLDeclarationAxiom extract(@NonNull IDA da) {
        OWLNamedIndividual individual = this.getOWLDataFactory().getOWLNamedIndividual(this.prefixedName2IRI(((I)da.getE()).getid()));
        return this.getSWRLAPIOWLDataFactory().getOWLIndividualDeclarationAxiom(individual);
    }

    @Override
    public @NonNull OWLDeclarationAxiom extract(@NonNull OPDA da) {
        OWLObjectProperty property = this.getOWLDataFactory().getOWLObjectProperty(this.prefixedName2IRI(da.getpid()));
        return this.getSWRLAPIOWLDataFactory().getOWLObjectPropertyDeclarationAxiom(property);
    }

    @Override
    public @NonNull OWLDeclarationAxiom extract(@NonNull DPDA da) {
        OWLDataProperty property = this.getOWLDataFactory().getOWLDataProperty(this.prefixedName2IRI(da.getpid()));
        return this.getSWRLAPIOWLDataFactory().getOWLDataPropertyDeclarationAxiom(property);
    }

    @Override
    public @NonNull OWLDeclarationAxiom extract(@NonNull APDA da) {
        OWLAnnotationProperty property = this.getOWLDataFactory().getOWLAnnotationProperty(this.prefixedName2IRI(da.getpid()));
        return this.getSWRLAPIOWLDataFactory().getOWLAnnotationPropertyDeclarationAxiom(property);
    }

    @Override
    public @NonNull OWLClassAssertionAxiom extract(@NonNull CAA caa) {
        OWLClassExpression cls = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(caa.getcid());
        OWLNamedIndividual individual = caa.getI().extract(this.getDroolsOWLEntityExtractor());
        return this.getOWLDataFactory().getOWLClassAssertionAxiom(cls, (OWLIndividual)individual);
    }

    @Override
    public @NonNull OWLObjectPropertyAssertionAxiom extract(@NonNull OPAA opaa) {
        OWLNamedIndividual subject = ((I)opaa.getT1()).extract(this.getDroolsOWLEntityExtractor());
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(opaa.getpid());
        OWLNamedIndividual object = ((I)opaa.getT3()).extract(this.getDroolsOWLEntityExtractor());
        return this.getOWLDataFactory().getOWLObjectPropertyAssertionAxiom(property, (OWLIndividual)subject, (OWLIndividual)object);
    }

    @Override
    public @NonNull OWLNegativeObjectPropertyAssertionAxiom extract(@NonNull NOPAA nopaa) {
        OWLNamedIndividual subject = nopaa.gets().extract(this.getDroolsOWLEntityExtractor());
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(nopaa.getpid());
        OWLNamedIndividual object = nopaa.geto().extract(this.getDroolsOWLEntityExtractor());
        return this.getOWLDataFactory().getOWLNegativeObjectPropertyAssertionAxiom(property, (OWLIndividual)subject, (OWLIndividual)object);
    }

    @Override
    public @NonNull OWLDataPropertyAssertionAxiom extract(@NonNull DPAA dpaa) {
        OWLNamedIndividual subject = dpaa.gets().extract(this.getDroolsOWLEntityExtractor());
        OWLDataPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(dpaa.getpid());
        OWLLiteral literal = this.getDroolsOWLLiteralExtractor().extract(dpaa.geto());
        return this.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(property, (OWLIndividual)subject, literal);
    }

    @Override
    public @NonNull OWLNegativeDataPropertyAssertionAxiom extract(@NonNull NDPAA ndpaa) {
        OWLNamedIndividual subject = ndpaa.gets().extract(this.getDroolsOWLEntityExtractor());
        OWLDataPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(ndpaa.getpid());
        OWLLiteral literal = this.getDroolsOWLLiteralExtractor().extract(ndpaa.geto());
        return this.getOWLDataFactory().getOWLNegativeDataPropertyAssertionAxiom(property, (OWLIndividual)subject, literal);
    }

    @Override
    public @NonNull OWLSameIndividualAxiom extract(@NonNull SIA sia) {
        OWLNamedIndividual individual1 = sia.geti1().extract(this.getDroolsOWLEntityExtractor());
        OWLNamedIndividual individual2 = sia.geti2().extract(this.getDroolsOWLEntityExtractor());
        HashSet<@NonNull OWLNamedIndividual> individuals = new HashSet<OWLNamedIndividual>();
        individuals.add(individual1);
        individuals.add(individual2);
        return this.getOWLDataFactory().getOWLSameIndividualAxiom(individuals);
    }

    @Override
    public @NonNull OWLDifferentIndividualsAxiom extract(@NonNull DIA dia) {
        OWLNamedIndividual individual1 = dia.geti1().extract(this.getDroolsOWLEntityExtractor());
        OWLNamedIndividual individual2 = dia.geti2().extract(this.getDroolsOWLEntityExtractor());
        HashSet<@NonNull OWLNamedIndividual> individuals = new HashSet<OWLNamedIndividual>();
        individuals.add(individual1);
        individuals.add(individual2);
        return this.getOWLDataFactory().getOWLDifferentIndividualsAxiom(individuals);
    }

    @Override
    public @NonNull OWLSubClassOfAxiom extract(@NonNull SCA sca) {
        OWLClassExpression superClass = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(sca.getsupercid());
        OWLClassExpression subClass = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(sca.getsubcid());
        return this.getOWLDataFactory().getOWLSubClassOfAxiom(subClass, superClass);
    }

    @Override
    public @NonNull OWLDisjointClassesAxiom extract(@NonNull DCA dca) {
        OWLClassExpression class1 = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(dca.getc1id());
        OWLClassExpression class2 = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(dca.getc2id());
        HashSet<@NonNull OWLClassExpression> classes = new HashSet<OWLClassExpression>();
        classes.add(class1);
        classes.add(class2);
        return this.getOWLDataFactory().getOWLDisjointClassesAxiom(classes);
    }

    @Override
    public @NonNull OWLEquivalentClassesAxiom extract(@NonNull ECA eca) {
        OWLClassExpression class1 = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(eca.getc1id());
        OWLClassExpression class2 = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(eca.getc2id());
        HashSet<@NonNull OWLClassExpression> classes = new HashSet<OWLClassExpression>();
        classes.add(class1);
        classes.add(class2);
        return this.getOWLDataFactory().getOWLEquivalentClassesAxiom(classes);
    }

    @Override
    public @NonNull OWLObjectPropertyDomainAxiom extract(@NonNull DOPA dopa) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(dopa.getpid());
        OWLClassExpression domain = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(dopa.getdid());
        return this.getOWLDataFactory().getOWLObjectPropertyDomainAxiom(property, domain);
    }

    @Override
    public @NonNull OWLDataPropertyDomainAxiom extract(@NonNull DDPA ddpa) {
        OWLDataPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(ddpa.getpid());
        OWLClassExpression domain = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(ddpa.getdid());
        return this.getOWLDataFactory().getOWLDataPropertyDomainAxiom(property, domain);
    }

    @Override
    public @NonNull OWLObjectPropertyRangeAxiom extract(@NonNull OPRA opra) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(opra.getpid());
        OWLClassExpression range = this.getDroolsOWLClassExpressionHandler().resolveOWLClassExpression(opra.getrid());
        return this.getOWLDataFactory().getOWLObjectPropertyRangeAxiom(property, range);
    }

    @Override
    public @NonNull OWLDataPropertyRangeAxiom extract(@NonNull DPRA dpra) {
        OWLDataPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(dpra.getpid());
        OWLDataRange range = this.getDroolsOWLDataRangeHandler().resolveOWLDataRange(dpra.getrid());
        return this.getOWLDataFactory().getOWLDataPropertyRangeAxiom(property, range);
    }

    @Override
    public @NonNull OWLSubObjectPropertyOfAxiom extract(@NonNull SOPA sopa) {
        OWLObjectPropertyExpression superProperty = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(sopa.getsuperpid());
        OWLObjectPropertyExpression subProperty = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(sopa.getsubpid());
        return this.getOWLDataFactory().getOWLSubObjectPropertyOfAxiom(subProperty, superProperty);
    }

    @Override
    public @NonNull OWLInverseObjectPropertiesAxiom extract(@NonNull IOPA iopa) {
        OWLObjectPropertyExpression property1 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(iopa.getp1id());
        OWLObjectPropertyExpression property2 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(iopa.getp2id());
        return this.getOWLDataFactory().getOWLInverseObjectPropertiesAxiom(property2, property1);
    }

    @Override
    public @NonNull OWLSubDataPropertyOfAxiom extract(@NonNull SDPA sdpa) {
        OWLDataPropertyExpression superProperty = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(sdpa.getsuperpid());
        OWLDataPropertyExpression subProperty = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(sdpa.getsubpid());
        return this.getOWLDataFactory().getOWLSubDataPropertyOfAxiom(subProperty, superProperty);
    }

    @Override
    public @NonNull OWLEquivalentObjectPropertiesAxiom extract(@NonNull EOPA eopa) {
        OWLObjectPropertyExpression property1 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(eopa.getp1id());
        OWLObjectPropertyExpression property2 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(eopa.getp1id());
        HashSet<@NonNull OWLObjectPropertyExpression> properties = new HashSet<OWLObjectPropertyExpression>();
        properties.add(property1);
        properties.add(property2);
        return this.getOWLDataFactory().getOWLEquivalentObjectPropertiesAxiom(properties);
    }

    @Override
    public @NonNull OWLEquivalentDataPropertiesAxiom extract(@NonNull EDPA edpa) {
        OWLDataPropertyExpression property1 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(edpa.getp1id());
        OWLDataPropertyExpression property2 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(edpa.getp2id());
        HashSet<@NonNull OWLDataPropertyExpression> properties = new HashSet<OWLDataPropertyExpression>();
        properties.add(property1);
        properties.add(property2);
        return this.getOWLDataFactory().getOWLEquivalentDataPropertiesAxiom(properties);
    }

    @Override
    public @NonNull OWLDisjointObjectPropertiesAxiom extract(@NonNull DJOPA djopa) {
        OWLObjectPropertyExpression property1 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(djopa.getp1id());
        OWLObjectPropertyExpression property2 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(djopa.getp2id());
        HashSet<@NonNull OWLObjectPropertyExpression> properties = new HashSet<OWLObjectPropertyExpression>();
        properties.add(property1);
        properties.add(property2);
        return this.getOWLDataFactory().getOWLDisjointObjectPropertiesAxiom(properties);
    }

    @Override
    public @NonNull OWLDisjointDataPropertiesAxiom extract(@NonNull DJDPA djdpa) {
        OWLDataPropertyExpression property1 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(djdpa.getp1id());
        OWLDataPropertyExpression property2 = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(djdpa.getp2id());
        HashSet<@NonNull OWLDataPropertyExpression> properties = new HashSet<OWLDataPropertyExpression>();
        properties.add(property1);
        properties.add(property2);
        return this.getOWLDataFactory().getOWLDisjointDataPropertiesAxiom(properties);
    }

    @Override
    public @NonNull OWLFunctionalObjectPropertyAxiom extract(@NonNull FOPA fopa) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(fopa.getpid());
        return this.getOWLDataFactory().getOWLFunctionalObjectPropertyAxiom(property);
    }

    @Override
    public @NonNull OWLFunctionalDataPropertyAxiom extract(@NonNull FDPA fdpa) {
        OWLDataPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLDataPropertyExpression(fdpa.getpid());
        return this.getOWLDataFactory().getOWLFunctionalDataPropertyAxiom(property);
    }

    @Override
    public @NonNull OWLInverseFunctionalObjectPropertyAxiom extract(@NonNull IFOPA ifopa) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(ifopa.getpid());
        return this.getOWLDataFactory().getOWLInverseFunctionalObjectPropertyAxiom(property);
    }

    @Override
    public @NonNull OWLIrreflexiveObjectPropertyAxiom extract(@NonNull IROPA iropa) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(iropa.getpid());
        return this.getOWLDataFactory().getOWLIrreflexiveObjectPropertyAxiom(property);
    }

    @Override
    public @NonNull OWLAsymmetricObjectPropertyAxiom extract(@NonNull AOPA aopa) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(aopa.getpid());
        return this.getOWLDataFactory().getOWLAsymmetricObjectPropertyAxiom(property);
    }

    @Override
    public @NonNull OWLSymmetricObjectPropertyAxiom extract(@NonNull SPA spa) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(spa.getpid());
        return this.getOWLDataFactory().getOWLSymmetricObjectPropertyAxiom(property);
    }

    @Override
    public @NonNull OWLTransitiveObjectPropertyAxiom extract(@NonNull TOPA topa) {
        OWLObjectPropertyExpression property = this.getDroolsOWLPropertyExpressionHandler().resolveOWLObjectPropertyExpression(topa.getpid());
        return this.getOWLDataFactory().getOWLTransitiveObjectPropertyAxiom(property);
    }

    private @NonNull DroolsOWLClassExpressionHandler getDroolsOWLClassExpressionHandler() {
        return this.droolsOWLClassExpressionHandler;
    }

    private @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }

    private @NonNull DroolsOWLDataRangeHandler getDroolsOWLDataRangeHandler() {
        return this.droolsOWLDataRangeHandler;
    }
}

