/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.factory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.extractors.TargetRuleEngineExtractorBase;
import org.swrlapi.drools.extractors.DroolsOWLEntityExtractor;
import org.swrlapi.drools.owl.classes.C;
import org.swrlapi.drools.owl.dataranges.D;
import org.swrlapi.drools.owl.individuals.I;
import org.swrlapi.drools.owl.properties.AP;
import org.swrlapi.drools.owl.properties.DP;
import org.swrlapi.drools.owl.properties.OP;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;

class DefaultDroolsOWLEntityExtractor
extends TargetRuleEngineExtractorBase
implements DroolsOWLEntityExtractor {
    public DefaultDroolsOWLEntityExtractor(@NonNull SWRLRuleEngineBridge bridge) {
        super(bridge);
    }

    @Override
    public @NonNull OWLClass extract(@NonNull C cls) throws TargetSWRLRuleEngineException {
        IRI classIRI = this.prefixedName2IRI(cls.getid());
        return this.getOWLDataFactory().getOWLClass(classIRI);
    }

    @Override
    public @NonNull OWLNamedIndividual extract(@NonNull I individual) throws TargetSWRLRuleEngineException {
        IRI individualIRI = this.prefixedName2IRI(individual.getid());
        return this.getOWLDataFactory().getOWLNamedIndividual(individualIRI);
    }

    @Override
    public @NonNull OWLDataProperty extract(@NonNull DP property) throws TargetSWRLRuleEngineException {
        IRI propertyIRI = this.prefixedName2IRI(property.getid());
        return this.getOWLDataFactory().getOWLDataProperty(propertyIRI);
    }

    @Override
    public @NonNull OWLAnnotationProperty extract(@NonNull AP property) throws TargetSWRLRuleEngineException {
        IRI propertyIRI = this.prefixedName2IRI(property.getid());
        return this.getOWLDataFactory().getOWLAnnotationProperty(propertyIRI);
    }

    @Override
    public @NonNull OWLObjectProperty extract(@NonNull OP property) throws TargetSWRLRuleEngineException {
        IRI propertyIRI = this.prefixedName2IRI(property.getid());
        return this.getOWLDataFactory().getOWLObjectProperty(propertyIRI);
    }

    @Override
    public @NonNull OWLDatatype extract(@NonNull D datatype) throws TargetSWRLRuleEngineException {
        IRI datatypeIRI = this.prefixedName2IRI(datatype.getid());
        return this.getOWLDataFactory().getOWLDatatype(datatypeIRI);
    }
}

