/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.factory;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.TargetSWRLRuleEngineCreator;
import org.swrlapi.drools.converters.id.DroolsOWLDataRangeHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.core.DroolsSWRLRuleEngineCreator;
import org.swrlapi.drools.extractors.DroolsOWLAxiomExtractor;
import org.swrlapi.drools.extractors.DroolsOWLEntityExtractor;
import org.swrlapi.drools.extractors.DroolsOWLNamedIndividualExtractor;
import org.swrlapi.drools.factory.DefaultDroolsOWLAxiomExtractor;
import org.swrlapi.drools.factory.DefaultDroolsOWLEntityExtractor;
import org.swrlapi.drools.factory.DefaultDroolsOWLNamedIndividualExtractor;
import org.swrlapi.exceptions.SWRLAPIException;

public class DroolsFactory {
    private static final String DROOLS_ICON_NAME = "Drools.gif";

    public static @NonNull TargetSWRLRuleEngineCreator getSWRLRuleEngineCreator() {
        return new DroolsSWRLRuleEngineCreator();
    }

    public static @NonNull Icon getSWRLRuleEngineIcon() throws SWRLAPIException {
        URL url = DroolsFactory.class.getResource(DROOLS_ICON_NAME);
        if (url != null) {
            return new ImageIcon(url);
        }
        throw new SWRLAPIException("No Drools icon found!");
    }

    public static @NonNull DroolsOWLAxiomExtractor getDroolsOWLAxiomExtractor(@NonNull SWRLRuleEngineBridge bridge, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLDataRangeHandler droolsOWLDataRangeHandler) {
        return new DefaultDroolsOWLAxiomExtractor(bridge, droolsOWLClassExpressionHandler, droolsOWLPropertyExpressionHandler, droolsOWLDataRangeHandler);
    }

    public static @NonNull DroolsOWLEntityExtractor getDroolsOWLEntityExtractor(@NonNull SWRLRuleEngineBridge bridge) {
        return new DefaultDroolsOWLEntityExtractor(bridge);
    }

    public static @NonNull DroolsOWLNamedIndividualExtractor getDroolsOWLIndividualExtractor(@NonNull SWRLRuleEngineBridge bridge) {
        return new DefaultDroolsOWLNamedIndividualExtractor(bridge);
    }
}

