/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.owl.core;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class DroolsBinaryObject<T1, T2> {
    private final @NonNull T1 t1;
    private final @NonNull T2 t2;

    protected DroolsBinaryObject(@NonNull T1 t1, @NonNull T2 t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    public @NonNull T1 getT1() {
        return this.t1;
    }

    public @NonNull T2 getT2() {
        return this.t2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @NonNull @NonNull DroolsBinaryObject that = (DroolsBinaryObject)o;
        if (!Objects.equals(this.t1, that.t1)) {
            return false;
        }
        return Objects.equals(this.t2, that.t2);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int result = this.t1 != null ? this.t1.hashCode() : 0;
        result = 31 * result + (this.t2 != null ? this.t2.hashCode() : 0);
        return result;
    }

    @SideEffectFree
    public @NonNull String toString() {
        return "(" + this.t1 + ", " + this.t2 + ")";
    }
}

