/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.owl.core;

import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class DroolsNarySet<ID, E> {
    private final @NonNull ID id;
    private final @NonNull Set<@NonNull E> elements;

    protected DroolsNarySet(@NonNull ID id, @NonNull Set<@NonNull E> elements) {
        this.id = id;
        this.elements = elements;
    }

    public @NonNull ID getID() {
        return this.id;
    }

    public @NonNull Set<@NonNull E> getElements() {
        return this.elements;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SideEffectFree
    @Deterministic
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @NonNull @NonNull DroolsNarySet that = (DroolsNarySet)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return Objects.equals(this.elements, that.elements);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.elements != null ? this.elements.hashCode() : 0);
        return result;
    }

    @SideEffectFree
    @Deterministic
    public @NonNull String toString() {
        return "(id=" + this.id + ", elements=" + this.elements + ")";
    }
}

